//===================================================================
//
// sensor_hum.c (@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "sensor_hum.h"

#ifdef SENSOR_HUM_M
#include <avr/interrupt.h>
#include "arch.h"
#include "platform.h"
#include "intr.h"

static volatile UINT16 hum_counter;
const UINT16 rh_table[101] = 
{
        7351, 7338, 7326, 7313, 7300, 7288, 7275, 7262, 7249, 7237, 
        7224, 7212, 7199, 7187, 7174, 7162, 7150, 7137, 7125, 7112,
        7100, 7088, 7075, 7063, 7050, 7038, 7026, 7013, 7001, 6988,
        6979, 6964, 6951, 6939, 6927, 6915, 6902, 6881, 6878, 6865,
        6853, 6841, 6828, 6816, 6803, 6791, 6778, 6766, 6753, 6741,
        6728, 6715, 6702, 6690, 6677, 6664, 6651, 6638, 6626, 6613,
        6600, 6587, 6574, 6560, 6547, 6534, 6521, 6508, 6494, 6481,
        6468, 6454, 6440, 6427, 6413, 6399, 6385, 6371, 6358, 6344,
        6330, 6316, 6301, 6287, 6272, 6258, 6244, 6229, 6215, 6200,
        6186, 6171, 6155, 6140, 6125, 6109, 6094, 6079, 6064, 6048,
        6033
}; // 7351 (0%), 6033 (100%)

void nos_hum_init()
{
	_BIT_SET(DDRA, HUM_SENSOR_POWER_SW); // Output : humidity power switch
	_BIT_CLR(DDRD, HUM_SENSOR_CLK); // Input : humidity clock source (frequency), TIMER2
	TCCR2 |= (1 << CS22) | (1 << CS21) | (1 << CS20);
	NOS_HUM_POWER_OFF();
}

static UINT16 nos_hum_get_freq()
{
	nos_disable_interrupt();

	UINT16 humidity_freq = 0;
	hum_counter = 0;
	TCNT2 = 0;
	CLEAR_TIMER2_OVF_vect();
	ENABLE_TIMER2_OVF_vect();
	nos_delay_ms(1000); // delay 1 second
	humidity_freq = (UINT16)TCNT2 + hum_counter*256;

	nos_enable_interrupt();
	return humidity_freq;
}

UINT16 nos_hum_get_data()
{           
	UINT8 i;
	UINT16 hum_freq;
	hum_freq = nos_hum_get_freq()*0.9+1300; // compensation

	for (i=0; i < 100; ++i)
	{
		if ( hum_freq >= rh_table[i] )
		{
			return i;
		}
	}
	return 100;
}

ISR(TIMER2_OVF_vect)
{
	//NOS_ENTER_ISR();
	hum_counter++;
	//NOS_EXIT_ISR();
}

#endif
