//===================================================================
//
// sensor_hum.h (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef SENSOR_HUM_H
#define SENSOR_HUM_H
#include "kconf.h"
#ifdef SENSOR_HUM_M 


#include "common.h"
#include "adc.h"

#define NOS_HUM_POWER_ON()     do { _BIT_CLR(P1OUT, SCL); } while(0)  // ETS300
#define NOS_HUM_POWER_OFF()    do { _BIT_SET(P1OUT, SCL); } while(0)

#define CMD_RESET	0x1e
#define CMD_HUM_ADDR	5

void nos_hum_init(void);
INT8 hum_port_get_data(void);
void hum_port_int_enable(void);
void reset(void);
void initseq(void);
INT8 processCommand(int cmd);
void ack(void);
void readSensor(void);
UINT16 nos_hum_get_data(void);

#endif // SENSOR_HUM_M
#endif // ~SENSOR_HUM_H
