//===================================================================
//
// platform.h   (@haekim, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef PLATFORM_H
#define PLATFORM_H
#include "kconf.h"

#include <io.h>

#define SPI_PORT0			1	// Use port0. 
//#define SPI_PORT1			1	// Use port1. 
#define SPI_ENABLE()		do { _BIT_CLR(P4OUT, CSN); } while (0)
#define SPI_DISABLE()		do { _BIT_SET(P4OUT, CSN); } while (0)
#define SIMO                    SIMO0 // P3.1 - Output: SIMO (Slave Input Master Output)
#define SOMI                    SOMI0 // P3.2 - Input: SOMI (Slave Output Master Input)
#define SCK                     UCLK0 // P3.3 - Output: SCK (UCLK0)

#ifdef UART_M
#include "uart.h"
#define STDIN   1
#define STDOUT  1
#endif

#ifdef ADC_M
#include "adc.h"
#endif

#ifdef LED_M
#include "led.h"
#endif

#ifdef RF_M
#include "rf.h"
#endif

#ifdef SENSOR_RAIN_M
#include "sensor_rain.h"
#endif
#ifdef SENSOR_TEMP_M
#include "sensor_temp.h"
#endif
#ifdef SENSOR_ACC_M
#include "sensor_acc.h"
#endif

void nos_platform_init(void);

/*********************** PORT Definition ******************************/
// Port 1
#define FIFOP                   0 // P1.0 
#define FIFO                    3 // P1.3 - FIFO Access 
#define CCA                     4 // P1.4 - Input:  CCA from CC2420

// Port 2
//#define BAT_MON		0 // P2.0 - GIO0 Battery Monitor
//#define SENSOR2		1 // P2.1 - GIO1 Sensor 2

// Port 3

// Port 4
#define SFD                     1 // P4.1 - Input:  SFD from CC2420
#define CSN                     2 // P4.2 - Output: SPI Chip Select (CS_N)
//#define FLASH_CSN     	4 // P4.4 -
#define VREG_EN         	5 // P4.5 - CC2420 voltage regulator enable
#define RESET_N         	6 // P4.6 - CC2420 reset  

// Port 5
#define TEMP_SENSOR_POWER_SW	0 // P5.0 - Temp Sensor Power Switch (0: on, 1: off)
#define ACC_SENSOR_POWER_SW	0 // P5.0 - Acc Sensor Power Switch (0: on, 1: off)
#define RAIN_SENSOR_POWER_SW	1 // P5.1 - Rain Sensor Power Switch (0: off, 1: on)
#define SLP_MODE_SW		4 // P5.4 - Acc Sleep mode select
#define YLED                    5 // P5.5 - Output : Yellow LED
#define GLED                    6 // P5.6 - Output : Green LED

// Port 6
#define ADC_RAIN_CHANNEL	0 // P6.0 - ADC Rain IN
#define ADC_TEMP_CHANNEL	1 // P6.1 - ADC Temp IN
#define BAT_MON			3 // P6.3 - BAT_MON
#define ADC_ACC_XCHANNEL	4 // P6.4 - ADC X Sensor IN
#define ADC_ACC_YCHANNEL	5 // P6.5 - ADC Y Sensor IN
#define ADC_ACC_ZCHANNEL	6 // P6.6 - ADC Z Sensor IN
#endif	// PLATFORM_H
