//===================================================================
//
// sensor_acc.c (@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "sensor_acc.h"

#ifdef SENSOR_ACC_M
#include "adc.h"
#include "platform.h"

void nos_acc_init()
{
        _BIT_SET(P5DIR, ACC_SENSOR_POWER_SW); //
        _BIT_CLR(P5SEL, ACC_SENSOR_POWER_SW); // 
	ADC12CTL0 |= SHT0_8; // 8 bit hold time
	ADC12CTL1 |= SHP; // sample and hold, repeat single channel
}

UINT16 nos_acc_get_dataX()
{
        return (nos_adc_convert(ADC_ACC_XCHANNEL));
}
UINT16 nos_acc_get_dataY()
{
        return (nos_adc_convert(ADC_ACC_YCHANNEL));
}
UINT16 nos_acc_get_dataZ()
{
        return (nos_adc_convert(ADC_ACC_ZCHANNEL));
}
#endif
