//===================================================================
//
// sensor_rain.c (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "sensor_rain.h"

#ifdef SENSOR_RAIN_M
#include "adc.h"
#include "platform.h"

void nos_rain_init()
{
	_BIT_SET(P5DIR, RAIN_SENSOR_POWER_SW); // P5DIR : RAIN
	_BIT_CLR(P5SEL, RAIN_SENSOR_POWER_SW); // P5SEL : RAIN
}

UINT16 nos_rain_get_data()
{
        return (nos_adc_convert(ADC_RAIN_CHANNEL));
}

UINT8 nos_rain_detected()
{
	UINT16 data;

	data = nos_rain_get_data();
	
	return (data < 0x0010);
}
#endif
