//===================================================================
//
// led.h	(@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef LED_H
#define LED_H
#include "kconf.h"
#ifdef LED_M

#include "common.h"

#define NOS_LED_INIT() \
	do { \
		_BIT_SET(DDRA, RLED); \
		_BIT_SET(DDRA, GLED); \
		_BIT_SET(DDRA, YLED); \
		_BIT_SET(PORTA, RLED); \
		_BIT_SET(PORTA, GLED); \
		_BIT_SET(PORTA, YLED); \
	} while(0)
	
	
#define NOS_LED_ON(n) \
	do { \
		if ( n == 1 ) \
			_BIT_CLR(PORTA, RLED); \
		else if ( n == 2 ) \
			_BIT_CLR(PORTA, GLED); \
		else if ( n == 3 ) \
			_BIT_CLR(PORTA, YLED); \
		else { \
			_BIT_CLR(PORTA, RLED); \
			_BIT_CLR(PORTA, GLED); \
			_BIT_CLR(PORTA, YLED); \
		} \
	} while(0)

#define NOS_LED_OFF(n) \
	do { \
		if ( n == 1 ) \
			_BIT_SET(PORTA, RLED); \
		else if ( n == 2 ) \
			_BIT_SET(PORTA, GLED); \
		else if ( n == 3 ) \
			_BIT_SET(PORTA, YLED); \
		else { \
			_BIT_SET(PORTA, RLED); \
			_BIT_SET(PORTA, GLED); \
			_BIT_SET(PORTA, YLED); \
		} \
	} while(0)
	
#define NOS_LED_TOGGLE(n) \
	do { \
		if ( n == 1 ) \
			PORTA = PINA^(1 << RLED); \
		else if ( n == 2 ) \
			PORTA = PINA^(1 << GLED); \
		else if ( n == 3 ) \
			PORTA = PINA^(1 << YLED); \
		else { \
			PORTA = PINA^(1 << RLED); \
			PORTA = PINA^(1 << GLED); \
			PORTA = PINA^(1 << YLED); \
		} \
	} while(0)

#endif // LED_M
#endif // ~LED_H

