//===================================================================
//
// platform.h	(@haekim, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef PLATFORM_H
#define PLATFORM_H
#include "kconf.h"

#include <avr/io.h>

#ifdef UART_M
#include "uart.h"
#define STDIN	0
#define STDOUT	0
#endif

#ifdef ADC_M
#include "adc.h"
#endif

#ifdef LED_M
#include "led.h"
#endif

#ifdef RF_M
#include "rf.h"
#endif

#ifdef SENSOR_LIGHT_M
#include "sensor_light.h"
#endif
#ifdef SENSOR_TEMP_M
#include "sensor_temp.h"
#endif


#define SPI_ENABLE()		do { _BIT_CLR(PORTB, CSN); } while (0)
#define SPI_DISABLE()	do { _BIT_SET(PORTB, CSN); } while (0)

void nos_platform_init(void);

/*********************** PORT Definition ******************************/
// Port A
#define YLED			0 // PA.0 - Output : Yellow LED
#define GLED			1 // PA.1 - Output : Green LED
#define RLED			2 // PA.2 - Output : Red LED
//#define FLASH_CSN	3 // PA.3 -
#define VREG_EN		5 // PA.5 - CC2420 voltage regulator enable
#define RESET_N		6 // PA.6 - CC2420 reset  

// Port B
#define CSN			0 // PB.0 - Output: SPI Chip Select (CS_N)
#define SCK			1 // PB.1 - Output: SPI Serial Clock (SCLK)
#define MOSI			2 // MOSI - Output: SPI Master out - slave in (MOSI)
#define MISO			3 // MISO - Input:  SPI Master in - slave out (MISO)
#define FIFO			7 // PB.7 - Input:  FIFO from CC2420

// Port C

// Port D
#define UART1_RXD	2 // RXD1 - Input:  UART1 RXD
//#define AC_plus		2 // PD.2 -
#define UART1_TXD	3 // TXD1 - Output: UART1 TXD
//#define AC_minus	3 // PD.3 -
#define SFD			4 // ICP1 - Input:  SFD from CC2420
//#define FLASH_CLK	5 // PE.5 -
#define CCA			6 // PD.6 - Input:  CCA from CC2420

// Port E
#define LIGHT_SENSOR_POWER_SW	5 // PE.5 - Light Sensor Power Switch
#define TEMP_SENSOR_POWER_SW  	6 // PE.6 - Temp Sensor Power Switch
#define FIFOP						6 // INT6 - Input:  FIFOP from CC2420

// Port F
#define ADC_LIGHT_CHANNEL	1	////ADC1 - adc channel 1
#define ADC_TEMP_CHANNEL	1

#endif	// ~PLATFORM_H

