//===================================================================
//
// led.h	(@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef LED_H
#define LED_H
#include "kconf.h"
#ifdef LED_M

#include "common.h"

#define NOS_LED_INIT() \
	do { \
		_BIT_SET(DDRD, RLED); \
		_BIT_SET(DDRE, GLED); \
		_BIT_SET(DDRE, YLED); \
		_BIT_SET(PORTD, RLED); \
		_BIT_SET(PORTE, GLED); \
		_BIT_SET(PORTE, YLED); \
	} while(0)
	
	
#define NOS_LED_ON(n) \
	do { \
		if ( n == 1 ) \
			_BIT_CLR(PORTD, RLED); \
		else if ( n == 2 ) \
			_BIT_CLR(PORTE, GLED); \
		else if ( n == 3 ) \
			_BIT_CLR(PORTE, YLED); \
		else { \
			_BIT_CLR(PORTD, RLED); \
			_BIT_CLR(PORTE, GLED); \
			_BIT_CLR(PORTE, YLED); \
		} \
	} while(0)

#define NOS_LED_OFF(n) \
	do { \
		if ( n == 1 ) \
			_BIT_SET(PORTD, RLED); \
		else if ( n == 2 ) \
			_BIT_SET(PORTE, GLED); \
		else if ( n == 3 ) \
			_BIT_SET(PORTE, YLED); \
		else { \
			_BIT_SET(PORTD, RLED); \
			_BIT_SET(PORTE, GLED); \
			_BIT_SET(PORTE, YLED); \
		} \
	} while(0)
	
#define NOS_LED_TOGGLE(n) \
	do { \
		if ( n == 1 ) \
			PORTD = PIND^(1 << RLED); \
		else if ( n == 2 ) \
			PORTE = PINE^(1 << GLED); \
		else if ( n == 3 ) \
			PORTE = PINE^(1 << YLED); \
		else { \
			PORTD = PIND^(1 << RLED); \
			PORTE = PINE^(1 << GLED); \
			PORTE = PINE^(1 << YLED); \
		} \
	} while(0)

#endif // LED_M
#endif // ~LED_H

