//===================================================================
//
// rf.c (@jun361, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "rf.h"

#ifdef RF_M
#include <avr/io.h>
#include <avr/interrupt.h>
#include "platform.h"
#include "arch.h"
#include "critical_section.h"
#include "cc2420.h"	// CC2420
#include "spi.h"

static void (*callback_func)(void);

void nos_rf_init()
{
	RF_PORT_INIT();
	
	// Enables SPI, selects "master", clock rate FCK/2 and SPI mode 0
	SPI_INIT(SPI_MASTER, SPI_CLK_DIV_2, SPI_MODE0);
	        
	// Make sure that the voltage regulator is on, and that the reset pin is inactive
	RF_VREG_SET();
	nos_delay_ms(2);
	RF_RESET_SET();
	nos_delay_us(1);
	RF_RESET_CLR();
	nos_delay_us(5);

	cc2420_init();

	// Initialize the FIFOP External interrupt
	EICRA |= (1 << ISC01) | (1 << ISC00);	// Interrupt will be requested in rising edge of INT0
	callback_func = NULL;
}

void nos_set_rf_cb(void (*func)(void))
{
	callback_func = func;
}

ISR(INT0_vect)
{
	NOS_ENTER_ISR();
	if ( callback_func )
	{
		callback_func();
	}
	CLEAR_FIFOP_INTR();
	NOS_EXIT_ISR();
}

#endif //--- RF_M ---//

