//===================================================================
//
// actuator.h (@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef ACTUATOR_H
#define ACTUATOR_H
#include "kconf.h"
#ifdef ACTUATOR_M
#include "common.h"

#define NOS_ACTUATOR_INIT(id) \
	do { \
		switch (id) { \
			case 0: \
				_BIT_SET(DDRD, ACTUATOR0); \
				_BIT_CLR(PORTD, ACTUATOR0); \
				break; \
			case 1: \
				_BIT_SET(DDRF, ACTUATOR1); \
				_BIT_CLR(PORTF, ACTUATOR1); \
				break; \
			case 2: \
				_BIT_SET(DDRB, ACTUATOR2); \
				_BIT_CLR(PORTB, ACTUATOR2); \
				break; \
			case 3: \
				_BIT_SET(DDRB, ACTUATOR3); \
				_BIT_CLR(PORTB, ACTUATOR3); \
				break; \
			default: \
				break; \
		} \
	} while(0)
	
#define NOS_ACTUATOR_ON(id) \
	do { \
		switch (id) { \
			case 0: \
				_BIT_SET(PORTD, ACTUATOR0); \
				break; \
			case 1: \
				_BIT_SET(PORTF, ACTUATOR1); \
				break; \
			case 2: \
				_BIT_SET(PORTB, ACTUATOR2); \
				break; \
			case 3: \
				_BIT_SET(PORTB, ACTUATOR3); \
				break; \
			default: \
				break; \
		} \
	} while(0)
	
#define NOS_ACTUATOR_OFF(id) \
	do { \
		switch (id) { \
			case 0: \
				_BIT_CLR(PORTD, ACTUATOR0); \
				break; \
			case 1: \
				_BIT_CLR(PORTF, ACTUATOR1); \
				break; \
			case 2: \
				_BIT_CLR(PORTB, ACTUATOR2); \
				break; \
			case 3: \
				_BIT_CLR(PORTB, ACTUATOR3); \
				break; \
			default: \
				break; \
		} \
	} while(0)

#endif //--- ACTUATOR_M ---
#endif //--- ACTUATOR_H ---
