//===================================================================
//
// sensor_pir.c (@sheart, @haekim, @jun361)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "sensor_pir.h"

#ifdef SENSOR_PIR_M

#include <avr/interrupt.h>
#include "critical_section.h"


static void (*callback_func)(void);

void nos_pir_init()
{
	callback_func = NULL;
	_BIT_SET(DDRC, PIR_SENSOR_POWER_SW); // DDRC0 : PIR
	EICRB |= (1 << ISC71) | (0 << ISC70); //INT7 (PE7) keeps low level for some period after something has beed detected. So, we must generate interrupts on falling edge.
	ENABLE_PIR_INTR();	
}


void nos_pir_callback(void (*func)(void))
{
	callback_func = func;
}

ISR(INT7_vect)
{
	NOS_ENTER_ISR();
	if (callback_func)
	{
		callback_func();
	}
	NOS_EXIT_ISR();
}       
#endif
