//===================================================================
//
// platform.c	(@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "platform.h"

#ifdef HAL_M
MappingTable mtable[DEV_MAX];
#endif

void nos_platform_init()
{
#ifdef HAL_M
// ADC interface
	mtable[0].dev_name = "adcv_v1_0";
	mtable[0].powPort.port = PORT_C | PIN_0;
	mtable[0].powPort.enable = HIGH;
	mtable[0].dataPort.type = INT_ADC;
	mtable[0].dataPort.port[0] = PORT_F | PIN_0;
// Interrupt interface
	mtable[1].dev_name = "intr_v1_0";
	mtable[1].powPort.port = PORT_C | PIN_1;
	mtable[1].powPort.enable = HIGH;
	mtable[1].dataPort.type = INT_INTERRUPT;
	mtable[1].dataPort.port[0] = PORT_E | PIN_5;

	mtable[2].dev_name = "i2c_v1_0";
	mtable[2].powPort.port = PORT_C | PIN_2;
	mtable[2].powPort.enable = HIGH;
	mtable[2].dataPort.type = INT_I2C;
	mtable[2].dataPort.port[0] = PORT_D | PIN_0;
	mtable[2].dataPort.port[1] = PORT_D | PIN_1;
	
	nos_mappingTable = mtable;
#endif

#ifdef UART_M
  	nos_uart_init(STDOUT);
#endif

#ifdef RF_M
	nos_rf_init();
#endif

#ifdef LED_M
	NOS_LED_INIT();
#endif

#ifdef BUTTON_M
	nos_button_init();
#endif

#ifdef A9060_M
	a9060_func_connect();
#endif

#ifdef RE200B_M
	re200b_func_connect();
#endif

#ifdef SHT11_M
	sht11_func_connect();
#endif

}
