//===================================================================
//
// led.h	(@sheart, @haekim)
// Description : If you use Humidity sensor, you cannot use RED LED!
// modified by msyu for sky-z200
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef LED_H
#define LED_H
#include "kconf.h"
#ifdef LED_M
#include "common.h"

#define NOS_LED_INIT() \
	do { \
		_BIT_SET(DDRE, RLED); \
		_BIT_SET(DDRB, GLED); \
		_BIT_SET(PORTE, RLED); \
		_BIT_SET(PORTB, GLED); \
	} while(0)
	
	
#define NOS_LED_ON(n) \
	do { \
		if ( n == 1 ) \
			_BIT_CLR(PORTE, RLED); \
		else if ( n == 2 ) \
			_BIT_CLR(PORTB, GLED); \
		else { \
			_BIT_CLR(PORTA, RLED); \
			_BIT_CLR(PORTA, GLED); \
		} \
	} while(0)

#define NOS_LED_OFF(n) \
	do { \
		if ( n == 1 ) \
			_BIT_SET(PORTE, RLED); \
		else if ( n == 2 ) \
			_BIT_SET(PORTB, GLED); \
		else { \
			_BIT_SET(PORTE, RLED); \
			_BIT_SET(PORTB, GLED); \
		} \
	} while(0)
	
#define NOS_LED_TOGGLE(n) \
	do { \
		if ( n == 1 ) \
			PORTE = PINE^(1 << RLED); \
		else if ( n == 2 ) \
			PORTB = PINB^(1 << GLED); \
		else { \
			PORTE = PINE^(1 << RLED); \
			PORTB = PINB^(1 << GLED); \
	} \
	} while(0)

#endif // LED_M
#endif // ~LED_H


