//===================================================================
//
// platform.h (@haekim, @sheart)	
//
//modified by msyu for sky-z200
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef PLATFORM_H
#define PLATFORM_H
#include "kconf.h"

#include <avr/io.h>
#ifdef UART_M
#include "uart.h"
#define STDIN	1
#define STDOUT	1
#endif

#ifdef LED_M
#include "led.h"
#endif

#ifdef RF_M
#include "rf.h"
#endif

#define SPI_ENABLE()		do { _BIT_CLR(PORTB, CSN); } while (0)
#define SPI_DISABLE()	do { _BIT_SET(PORTB, CSN); } while (0)

void nos_platform_init(void);


/*********************** PORT Definition ******************************/

//PortA



//PortB
#define GLED	7

#define CSN			0 // PB.0 - Output: SPI Chip Select (CS_N)
#define SCK			1 // PB.1 - Output: SPI Serial Clock (SCLK)
#define MOSI		2 // MOSI - Output: SPI Master out - slave in (MOSI)
#define MISO		3 // MISO - Input:  SPI Master in - slave out (MISO)

#define VREG_EN		5 // PB.5 - CC2420 voltage regulator enable
#define RESET_N		6 // PB.6 - CC2420 reset  


//PortC



//PortD
#define FIFOP		0 // INT0 - Input:  FIFOP from CC2420
#define FIFO		1 // PD.1 - Input:  FIFO from CC2420

#define UART1_RXD	2 // RXD1 - Input:  UART1 RXD
#define UART1_TXD	3 // TXD1 - Output: UART1 TXD
#define SFD			4 // ICP1 - Input:  SFD from CC2420
#define CCA			6 // PD.6 - Input:  CCA from CC2420


//PortE
#define RLED	4


//PortF


#endif	// ~PLATFORM_H

