//===================================================================
//
// platform.h   (@haekim, @sheart, @jun361)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
// 07.07.26 @jun361 : NOT complete about sensor & flash 

#ifndef PLATFORM_H
#define PLATFORM_H
#include "kconf.h"

#define SPI_PORT0			1	// Use port0. 
//#define SPI_PORT1			1	// Use port1. 
#define SPI_ENABLE()		do { _BIT_CLR(P4OUT, CSN); } while (0)
#define SPI_DISABLE()		do { _BIT_SET(P4OUT, CSN); } while (0)
#define SIMO                    SIMO0 // P3.1 - Output: SIMO (Slave Input Master Output)
#define SOMI                    SOMI0 // P3.2 - Input: SOMI (Slave Output Master Input)
#define SCK                     UCLK0 // P3.3 - Output: SCK (UCLK0)

#ifdef UART_M
#include "uart.h"
#define STDIN   1
#define STDOUT  1
#endif

#ifdef ADC_M
#include "adc.h"
#endif

#ifdef LED_M
#include "led.h"
#endif

#ifdef RF_M
#include "rf.h"
#endif

#ifdef SENSOR_HUM_M
#include "sensor_hum.h"
#endif
#ifdef SENSOR_TEMP_M
#include "sensor_temp.h"
#endif


void nos_platform_init(void);

/*********************** PORT Definition ******************************/
// Port 1
#define FIFOP                   0 // P1.0 
#define FIFO                    3 // P1.3 - FIFO Access 
#define CCA                     4 // P1.4 - Input:  CCA from CC2420
#define SDA			5	//  P1.5 HUM_SDA
#define SCL			6	//  P1.6 HUM_SCL
#define	HUM_SENSOR_PWR			7	//  P1.7 HUM_PWR

// Port 2
#define ONEWIRE_SERIAL_ID		4 //P2.4 - 1-Wire : serial id check

// Port 3

// Port 4
#define SFD                     1 // P4.1 - Input:  SFD from CC2420
#define CSN                     2 // P4.2 - Output: SPI Chip Select (CS_N) 
#define VREG_EN         		5 // P4.5 - CC2420 voltage regulator enable
#define RESET_N		        	6 // P4.6 - CC2420 reset  

// Port 5
#define RLED                    4 // P5.4 - Output : LED1
#define GLED                    5 // P5.5 - Output : LED2
#define BLED                    6 // P5.6 - Output : LED3


#endif	// PLATFORM_H
