//===================================================================
//
// rf.h (@jun361, @haekim)
//              
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef RF_H
#define RF_H
#include "kconf.h"
#ifdef RF_M

#include "common.h"     // msp430 + isn-400n platform

#define RF_RESET_SET()          do { _BIT_CLR(P4OUT, RESET_N); } while (0)
#define RF_RESET_CLR()        do { _BIT_SET(P4OUT, RESET_N); } while (0)                                                       
#define RF_VREG_SET()           do { _BIT_SET(P4OUT, VREG_EN); } while (0)
#define RF_VREG_CLR()         do { _BIT_CLR(P4OUT, VREG_EN); } while (0)
#define RF_PORT_INIT() \
do { \
	P4DIR |= (1 << VREG_EN); \
    P4DIR |= (1 << CSN);                   \
	P1DIR &= ~((1 << FIFOP)|(1 << FIFO)|(1 << CCA)); \
	P4DIR &= ~(1 << SFD);			\
    P4DIR |= (1 << RESET_N); \
    P3SEL |= (1 << SIMO) | (1 << SOMI) | (1 << SCK); \
    P3DIR |= (1 << SIMO) | (1 << SCK);     \
	P3DIR &= ~(1 << SOMI); 			\
    SPI_DISABLE(); \
} while (0)

// SFD interrupt
//#define ENABLE_SFD_CAPTURE_INTR()    do { ENABLE_TIMER1_CAPT_vect(); } while(0)
//#define DISABLE_SFD_CAPTURE_INTR()   do { DISABLE_TIMER1_CAPT_vect(); } while (0)
//#define CLEAR_SFD_CAPTURE_INTR()     do { CLEAR_TIMER1_CAPT_vect(); } while (0)

// FIFOP interrupt
#define ENABLE_FIFOP_INTR()          do { _BIT_SET(P1IE, FIFOP); } while (0)
#define DISABLE_FIFOP_INTR()         do { _BIT_CLR(P1IE, FIFOP); } while (0)
#define CLEAR_FIFOP_INTR()           do { _BIT_CLR(P1IFG, FIFOP); } while (0)       
#define IS_SET_FIFOP_INTRFLAG()		_IS_SET(P1IFG, FIFOP)

// Pin status
#define RF_RESET_IS_SET()       _IS_SET(P4IN, RESET_N)
#define RF_VREG_IS_SET()        _IS_SET(P4IN, VREG_EN)
#define RF_FIFOP_IS_SET()       _IS_SET(P1IN, FIFOP)
#define RF_FIFO_IS_SET()        _IS_SET(P1IN, FIFO)
#define RF_SFD_IS_SET()         _IS_SET(P4IN, SFD)
#define RF_CCA_IS_SET()         _IS_SET(P1IN, CCA)
#define RF_RXFIFO_OVERFLOW()    ((RF_FIFOP_IS_SET()) && (!(RF_FIFO_IS_SET())))

// Functions and Variables
void nos_rf_init(void);
void nos_set_rf_cb(void (*func)(void));

#endif // RF_M
#endif // ~RF_H
