//========================================================================
// File		: uart_get.c 
// Author	: Haeyong Kim (haekim@etri.re.kr)
// Date		: 2006.06.01
// Description : Receive string from the keyboard.
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================

//-------------- Terminal setting -----------------------
// Data bit	: 8 bit
// Stop bit	: 1 bit
// Parity	: none
//-------------------------------------------------------

#include "nos.h"

#define MAX_STRLEN 10 // You can change this value as you want.

INT8 str[MAX_STRLEN];

void uart_rx_handler (UINT8 rx_char)
{
	if (rx_char == '1')
	{
		led_toggle(1);
		uart_printf("\nLED1 has toggled.");
	}
	else if (rx_char == '2')
	{
		led_toggle(2);
		uart_printf("\nLED2 has toggled.");
	}
	else if (rx_char == '3')
	{
		led_toggle(3);
		uart_printf("\nLED3 has toggled.");
	}
	else
	{
		led_off(1);
		led_off(2);
		led_off(3);
	}
}

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");
	
	uart_getc_callback (uart_rx_handler);
	enable_uart_rx_intr();
	
	while (1)
	{
		// uart_rx_handler is not called while "nos_uart_gets" is calling. Input 'Enter' for termination.
		uart_puts("\n\n\rType anything (up to 9characters), and then press 'Enter'.\n\r");
		uart_gets(str, sizeof(str));
		uart_puts("You typed : ");
		uart_puts(str);
		uart_puts("\n\r");

		// You can change LED state  for 10sec by calling "uart_rx_handler" 
		uart_puts("\r\nType '1', '2', '3' to change LED state.");
		delay_ms(10000);
	}

	return 0;
}
