//===================================================================
//
// eeprom.c (@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "nos.h"

#define MAX_STRLEN 100

int main(void)
{
	INT8 str[MAX_STRLEN];
	UINT16 write_addr = 0;
	UINT16 read_addr = 0;
	UINT8 read_len = 0;

	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");
	uart_printf("\nEEPROM write/read test.");

	while (1)
	{
		uart_puts("\n\rWrite? (1) or Read? (2) : ");
		uart_gets(str, 2);

		if (str[0] == '1')
		{
			uart_printf("Input a string to write : ");
			uart_gets(str, MAX_STRLEN);
			// write a string 'str' in 'rom_addr' address of eeprom
			uart_printf("Writing \"%s\" into address 0x(%x) in EEPROM ...", str, write_addr);
			eeprom_write_block(write_addr, str, strlen(str));
			write_addr+= strlen(str);
			uart_printf("\t%d byte has been written.\n", write_addr);
		}
		else if (str[0] == '2')
		{
			uart_printf("Input EEPROM address : ");
			uart_gets(str, 6);
			read_addr = atoi(str);
			uart_printf("Input a string length to read : ");
			uart_gets(str, 4);
			read_len = atoi(str);

			// read a string from eeprom
			uart_printf("Reading %d byte from address 0x(%x) in EEPROM ...\n", read_len, read_addr);
			eeprom_read_block(read_addr, str, read_len);
			str[read_len] = '\0';
			uart_printf("%s\nRead done.\n", str);
		}
	}

	return 0;
}
