//========================================================================
// File		: thread_join.c
// Author	: @sheart
// Date		: 2006.09.24
// Description : Thread Joining Test Program
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================
#include "nos.h"

void do_loop(UINT8 id, UINT16 cnt)
{
	UINT8 i,j;
	for (i=1; i<cnt; ++i)
	{
		ENTER_CRITICAL();
		uart_printf("\nTask%d is now working. - ", id);
		for (j=0; j<i; ++j)
		{
			uart_puts("*");
		}
		EXIT_CRITICAL();
		delay_ms(100);	// To slow down uart printf speed
	}
}

void task2(void *args)
{
	do_loop(get_thread_id(), 40);
	uart_printf("\n===Task%d : I am done. Bye~===", get_thread_id());
}

void task1(void *args)
{
	UINT8 child_thread_id;
	UINT8 my_id = get_thread_id();
	while (1)
	{
		uart_printf("\n\n===Task%d : I'll make a child thread===", my_id);
		child_thread_id = thread_create(task2, NULL, 0, PRIORITY_NORMAL);
		do_loop(my_id, 10);
		uart_printf("\n===Task%d : My work has been done. But I'll wait until Task%d is completed===" , my_id, child_thread_id);
		// wait until child thread completes.
		nos_thread_join(child_thread_id);
		uart_printf("\n===Task%d : OK. Child task has been done.===", my_id);
		thread_sleep_sec(3);
	}
}

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***");

	thread_create(task1, NULL, 0, PRIORITY_NORMAL); 

	sched_start();

   	return 0;
}
