//========================================================================
// File		: priority_change.c 
// Author	: @sheart
// Date		: 2006.09.25
// Description  : Thread Priority Change Test Program
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================
#include "nos.h"

UINT8 pri_jump_tid;

void do_loop(UINT8 id)
{
	UINT8 i,j,my_prior;
	for (i=1; i<15; ++i)
	{
		ENTER_CRITICAL();
		my_prior = get_thread_prior(get_thread_id());
		if (my_prior == PRIORITY_LOW)
		{
			uart_printf("\n(LOW)Task%d is now working. - ", id);
		}
		else
		{
			uart_printf("\n(NORMAL)Task%d is now working. - ", id);
		}
		for (j=0; j<i; ++j)
		{
			uart_puts("*");
		}
		EXIT_CRITICAL();
		delay_ms(100);	// To slow down uart printf speed
	}
}


void task1(void *args)
{
	UINT8 my_id = get_thread_id();
	while(1)
	{
		do_loop(my_id);

		// change the priority of task3 into "NORMAL"
		ENTER_CRITICAL();
		uart_printf("\n===Task%d : I will change the the priority of Task%d to \"PRIORITY_NORMAL\".\n", my_id, pri_jump_tid);
		thread_priority_change(pri_jump_tid, PRIORITY_NORMAL);
		EXIT_CRITICAL();
	}
}

void task2(void *args)
{
	UINT8 my_id = get_thread_id();
	while(1)
	{
		do_loop(my_id);
		// change the priority of task3 into "LOW"

		ENTER_CRITICAL();
		uart_printf("\n===Task%d : I will change the the priority of Task%d to \"PRIORITY_LOW\".\n", my_id, pri_jump_tid);
		thread_priority_change(pri_jump_tid, PRIORITY_LOW);
		EXIT_CRITICAL();

		do_loop(my_id);

		ENTER_CRITICAL();
		uart_printf("\n===Task%d : I'll sleep for a while.\n", my_id);
		thread_sleep_sec(5);
		EXIT_CRITICAL();

		uart_printf("\n\n===Task%d : I've just awaken.", my_id);
	}
}

void task3(void *args)
{
	UINT8 my_id = get_thread_id();
	while(1)
	{
		do_loop(my_id);
	}
}

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	thread_create(task1, NULL, 0, PRIORITY_LOW); 	
	thread_create(task2, NULL, 0, PRIORITY_NORMAL); 
	pri_jump_tid = thread_create(task3, NULL, 0, PRIORITY_NORMAL);

	sched_start();

   	return 0;
}
