//========================================================================
// File		: thread_info.c 
// Author	: @sheart
// Date		: 2006.10.24
// Description : Thread Info
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================
#include "nos.h"
#include "string.h"

UINT8 task1_id, task2_id, task3_id;

void print_thread_info(void)
{
	UINT8 id; 
	INT8 buf[9];

	ENTER_CRITICAL();
	for (id = 1; id <= MAX_NUM_USER_THREAD; ++id)
	{
		if (id == task1_id || id == task2_id || id == task3_id)
		{
			switch (get_thread_state(id))
			{
				case 1 : strcpy(buf, "READY"); break;
				case 2 : strcpy(buf, "RUNNING"); break;
				case 3 : strcpy(buf, "WAITING"); break;
				case 4 : strcpy(buf, "SLEEPING"); break;
				case 5 : strcpy(buf, "EXIT"); break;
				default : break;
			}
			uart_printf("\nTask%d : %s, priority : %d,  %ubyte(s) stack left.", id, buf, get_thread_prior(id), get_thread_stack_unused_space(id));
		}
	}
	uart_printf("\n");
	EXIT_CRITICAL();
}

void task1(void *args)
{
	while (1)
	{
		print_thread_info();
		delay_ms(1000);
	}
}

void task2(void *args)
{
	while (1)
	{
		print_thread_info();
		thread_sleep_ms(1250);
	}
}

void task3(void *args)
{
	while (1)
	{
		print_thread_info();
		thread_sleep_ms(1750);
	}
}

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	task1_id = thread_create(task1, NULL, 9, PRIORITY_LOW); 	
	task2_id = thread_create(task2, NULL, 9, PRIORITY_NORMAL); 
	task3_id = thread_create(task3, NULL, 9, PRIORITY_HIGH);

	sched_start();

   	return 0;
}
