//========================================================================
// File		: taskq.c 
// Author	: @sheart
// Date		: 2007.11.15
// Description  : Task queue test program
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================
#include "nos.h"

UINT8 cnt;

void print_hello(void)
{
	UINT8 i,j;
	uart_printf("\nRegistered Task%d : I am running from TASK QUEUE, so I am the HIGHEST priority task.", cnt);
	for (i=0; i<10; i++) {
		ENTER_CRITICAL();
		uart_printf("\nRegistered Task%d is now working. - ", cnt);
		for (j=0; j<i; ++j)
		{
			uart_puts("*");
		}
		EXIT_CRITICAL();
		delay_ms(100);	// To slow down uart printf speed
	}
}

void do_loop(UINT8 id)
{
	UINT8 i,j;
	for (i=1; i<10; ++i)
	{
		ENTER_CRITICAL();
		uart_printf("\nTask%d is now working. - ", id);
		for (j=0; j<i; ++j)
		{
			uart_puts("*");
		}
		EXIT_CRITICAL();
		delay_ms(100);	// To slow down uart printf speed
	}
}


void task1(void *args)
{
	while (1)
	{
		uart_printf("\nTASK1 : I am a thread with LOW priority.");
		do_loop(1);
		taskq_reg(print_hello);
		++cnt;
	}
}

void task2(void *args)
{
	while (1)
	{
		uart_printf("\nTASK2 : I am a thread with NORMAL priority.");
		do_loop(2);
		taskq_reg(print_hello);
		++cnt;
		uart_printf("\nTASK2 : I'll sleep for a while for LOW priority thread.");
		thread_sleep_sec(2);
	}
}

void task3(void *args)
{
	while (1)
	{
		uart_printf("\nTASK3 : I am a thread with LOW priority.\n");
		do_loop(3);
		taskq_reg(print_hello);
		++cnt;
	}
}

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");
	cnt = 0;

	thread_create(task1, NULL, 0, PRIORITY_LOW); 	
	thread_create(task2, NULL, 0, PRIORITY_NORMAL); 
	thread_create(task3, NULL, 0, PRIORITY_LOW); 

	sched_start();

   	return 0;
}
