//========================================================================
// File		: timer.c 
// Author	: @sheart
// Date		: 2007.07.29
// Description : timer function
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================
#include "nos.h"

UINT8 led_id = 1;

void oneshot2(void)
{
	uart_printf("\n\n===One-shot Timer2 : Hello.\n");
}

void oneshot1(void)
{
	ENTER_CRITICAL();
	timer_create_sec(oneshot2, 5, TIMER_ONE_SHOT); // after 1 sec, one time
	uart_printf("\n\n===One-shot Timer1 : I am running now and \"One-shot Timer2\" has been created. It will runs after 5sec.\n");
	EXIT_CRITICAL();
}

void periodic_print(void)
{
	uart_printf("\n===This message will be shown every 5sec by periodic timer.");
}

void led_blink(void)
{
	led_id++;
    	led_off(1+(led_id%3));
	led_on((1+(led_id+1)%3));               
}

void running(UINT8 id)
{
	uart_printf("\nTask%d is now running.", id);
	thread_sleep_sec(1);
}

void task1(void *args)
{
	int i;
	while (1)
	{
		ENTER_CRITICAL();
		timer_create_sec(oneshot1, 2, TIMER_ONE_SHOT); // after 1 sec, one time
		uart_printf("\n\nTask1 : \"One-shot Timer1\" has been created. It will runs after 2sec.\n");
		EXIT_CRITICAL();
		for (i=0; i<12; ++i)
		{
			running(1);
		}
	}
}

void task2(void *args)
{
	while (1)
	{
		running(2);
	}
}

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	thread_create(task1, NULL, 0, PRIORITY_NORMAL); 	
	thread_create(task2, NULL, 0, PRIORITY_NORMAL); 

	timer_create_sec(periodic_print, 5, TIMER_PERIODIC); // every 5 secs
	timer_create_ms(led_blink, 100, TIMER_PERIODIC); // every 200ms 

	sched_start();

   	return 0;
}
