//===================================================================
//
// reno_rx_non_callback.c (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "nos.h"

UINT8 src_id;
UINT8 length;
UINT8 data[NWK_MAX_PAYLOAD_SIZE]; //108


// RX thread
void task1(void* args)
{
	while (TRUE)
	{
		while ( nwk_rx(&src_id, &length, data) )
		{
			led_toggle(3);		
			uart_printf("RX : %u\n",data[0]);
		}
	}
}

int main(void) 
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	// Initializing  [ Channel:0x0B~0x1A (11~26), PAN ID : 0x0000~0xfffE(0~65534), Node ID(MAC short address) : 0~255 ] 
	nwk_init(0x1A, 0x312, 1, 0, 255);
	
 	uart_printf("RF Channel : 0x1A \nPAN address: 0x312 \nID : 1\nReceivable Range : 0 ~ 255\n");

	thread_create(task1, NULL, 0, PRIORITY_NORMAL);	// stack size is 108 not 0 because of data[] in task1.
	
	sched_start();

	return 0;
} // main
