//===================================================================
//
// us.c (@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "nos.h"

void us_intr_handler(void)
{
	uart_puts("\n\rDistance : ");
	uart_putu(us_get_data());
	uart_puts("cm\n\r");
}

int main(void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");
	
	us_power_on();	// turn on US sensor
	us_callback(us_intr_handler);
	
	while(1)
	{
		uart_puts("\n\rTriggering..");
		us_trigger();		// Turn interrupt on while triggering
		delay_ms(1000);
	}
	us_power_off(); // turn off US sensor
	return 0;
} // end of main 
