//===================================================================
//
// pir.c (@jun123, @sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "nos.h"

// Interrupt occurs when detected object is gone.
void pir_intr_handler(void)
{
	uart_puts("\n\r\tPIR Detected!\n\r");
}

int main(void) 
{	
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");
	
	pir_power_on(); // power on PIR SENSOR sensor 
	pir_callback(pir_intr_handler);

	while (TRUE)
	{
		uart_putc(_BS);	
		uart_putc('-');
		delay_ms(200);
		uart_putc(_BS);
		uart_putc('\\');
		delay_ms(200);
		uart_putc(_BS);		
		uart_putc('|');
		delay_ms(200);
		uart_putc(_BS);		
		uart_putc('/');
		delay_ms(200);
	}

	pir_power_off(); // power off PIR SENSOR sensor 
	
	return 0;
} 
