//========================================================================
// File		: hal.c 
// Author	: Youngbum Park (youngbumpark@gmail.com)
// Date		: 2008.08.08
// Description : hal layer process test (ADC)
//========================================================================
// Copyright 2008 - 2014, HCI Lab
//========================================================================

//-------------- Terminal setting -----------------------
// Data bit		: 8 bit
// Stop bit		: 1 bit
// Parity		: none
//-------------------------------------------------------

#include "nos.h"

#define ADC_V3			0
#define INTERRUPT_V3	1

void interrupt_callback_function(void)
{
	led_toggle(1);
	delay_us(1);
	led_toggle(2);
	uart_printf("Interrupt Service Routine\n");	
}

int main (void)
{
	nos_init();
	uart_printf("\n Octacomm Sensor Hardware Interface Board Test \n");
	delay_ms(5000); // Do sensing every 1 second	
	led_on(3);

	int fd1;

	fd1 = device_connect("interrupt","intr_v1_0","re200b");

	Open(fd1);

	Ioctl(fd1 , 0, 1, NULL);  // Power On

	Ioctl(fd1, 1, 1, interrupt_callback_function);
	while(1);
	return 0;
}

