//===================================================================
//
// test.c (@sheart)
//
//===================================================================

//===================================================================
#include "nos.h"
#include "device_driver.h"

int main(void) 
{	
	nos_init();
	uart_printf("\n*** Nano OS ***\n");

	delay_ms(3000); // Do sensing every 1 second		
	int fd1;

	Read_Data light_data ; 

	fd1 = device_connect("light_dve","adcv_v1_0","a9060");
	
	uart_printf("\n*** device_connect fd: %d ***\n", fd1);

	// a9060
	Open(fd1);
	
	Ioctl(fd1, 0,1, NULL); // power On

	led_on(2);
	
	while(1)
	{
		led_on(3);
		delay_ms(1000); // Do sensing every 1 second		
		float readdata = Read(fd1) ; 
		uart_printf("Current Brightness of Light 1: %f lux\n",readdata);
		delay_ms(1000); // Do sensing every 1 second		
	}

	delay_ms(10000); // Do sensing every 1 second	
	Close(fd1);	// power off TEMP sensor 
	return 0;
}
