module HALI2CM {
	provides {
		interface HALI2C;
	}
}

implementation {

	command result_t HALI2C.sckInit(uint8_t port){
		switch(port & 0xF0)
		{
		case 0x00:	sbi(DDRA, (port&0x0F));		break;
		case 0x10:	sbi(DDRB, (port&0x0F));		break;
		case 0x20:	sbi(DDRC, (port&0x0F));		break;
		case 0x30:	sbi(DDRD, (port&0x0F));		break;
		case 0x40:	sbi(DDRE, (port&0x0F));		break;
		case 0x50:	sbi(DDRF, (port&0x0F));		break;
		default :	break;
		}

		return SUCCESS;
	}

	command result_t HALI2C.dataOutput(uint8_t port){
		switch(port & 0xF0)
		{
		case 0x00:	sbi(DDRA, (port&0x0F));		break;
		case 0x10:	sbi(DDRB, (port&0x0F));		break;
		case 0x20:	sbi(DDRC, (port&0x0F));		break;
		case 0x30:	sbi(DDRD, (port&0x0F));		break;
		case 0x40:	sbi(DDRE, (port&0x0F));		break;
		case 0x50:	sbi(DDRF, (port&0x0F));		break;
		default :	break;
		}

		return SUCCESS;
	}

	command result_t HALI2C.dataInput(uint8_t port){
		switch(port & 0xF0)
		{
		case 0x00:	cbi(DDRA, (port&0x0F));	sbi(PORTA, (port&0x0F));	break;
		case 0x10:	cbi(DDRB, (port&0x0F));	sbi(PORTB, (port&0x0F));	break;
		case 0x20:	cbi(DDRC, (port&0x0F));	sbi(PORTC, (port&0x0F));	break;
		case 0x30:	cbi(DDRD, (port&0x0F));	sbi(PORTD, (port&0x0F));	break;
		case 0x40:	cbi(DDRE, (port&0x0F));	sbi(PORTE, (port&0x0F));	break;
		case 0x50:	cbi(DDRF, (port&0x0F));	sbi(PORTF, (port&0x0F));	break;
		default :	break;
		}

		return SUCCESS;
	}

	command result_t HALI2C.sckHigh(uint8_t port){
		switch(port & 0xF0)
		{
		case 0x00:	sbi(PORTA, (port&0x0F));	break;
		case 0x10:	sbi(PORTB, (port&0x0F));	break;
		case 0x20:	sbi(PORTC, (port&0x0F));	break;
		case 0x30:	sbi(PORTD, (port&0x0F));	break;
		case 0x40:	sbi(PORTE, (port&0x0F));	break;
		case 0x50:	sbi(PORTF, (port&0x0F));	break;
		default :	break;
		}

		return SUCCESS;
	}

	command result_t HALI2C.sckLow(uint8_t port){
		switch(port & 0xF0)
		{
		case 0x00:	cbi(PORTA, (port&0x0F));	break;
		case 0x10:	cbi(PORTB, (port&0x0F));	break;
		case 0x20:	cbi(PORTC, (port&0x0F));	break;
		case 0x30:	cbi(PORTD, (port&0x0F));	break;
		case 0x40:	cbi(PORTE, (port&0x0F));	break;
		case 0x50:	cbi(PORTF, (port&0x0F));	break;
		default :	break;
		}

		return SUCCESS;
	}

	command result_t HALI2C.dataHigh(uint8_t port){
		switch(port & 0xF0)
		{
		case 0x00:	sbi(PORTA, (port&0x0F));	break;
		case 0x10:	sbi(PORTB, (port&0x0F));	break;
		case 0x20:	sbi(PORTC, (port&0x0F));	break;
		case 0x30:	sbi(PORTD, (port&0x0F));	break;
		case 0x40:	sbi(PORTE, (port&0x0F));	break;
		case 0x50:	sbi(PORTF, (port&0x0F));	break;
		default :	break;
		}

		return SUCCESS;
	}

	command result_t HALI2C.dataLow(uint8_t port){
		switch(port & 0xF0)
		{
		case 0x00:	cbi(PORTA, (port&0x0F));	break;
		case 0x10:	cbi(PORTB, (port&0x0F));	break;
		case 0x20:	cbi(PORTC, (port&0x0F));	break;
		case 0x30:	cbi(PORTD, (port&0x0F));	break;
		case 0x40:	cbi(PORTE, (port&0x0F));	break;
		case 0x50:	cbi(PORTF, (port&0x0F));	break;
		default :	break;
		}

		return SUCCESS;
	}

	command result_t HALI2C.dataRead(uint8_t port){
		uint8_t return_value = 0x00;
		switch(port & 0xF0)
		{
		case 0x00:	return_value = inp(PINA);	break;
		case 0x10:	return_value = inp(PINB);	break;
		case 0x20:	return_value = inp(PINC);	break;
		case 0x30:	return_value = inp(PIND);	break;
		case 0x40:	return_value = inp(PINE);	break;
		case 0x50:	return_value = inp(PINF);	break;
		default :	break;
		}
		return_value &= (1<<(port&0x0F));

		return !!return_value;
	}

}

