module HALINTR0M {
	provides {
		interface HALINTERRUPT;
	}
}

implementation {

	command result_t HALINTERRUPT.open(uint8_t enable){
		sbi(EIMSK, 0);

		switch(enable)
		{
		case 0:
			cbi(EICRA, 1);
			cbi(EICRA, 0);
			break;
		case 1:
			cbi(EICRA, 1);
			sbi(EICRA, 0);
			break;
		case 2:
			sbi(EICRA, 1);
			cbi(EICRA, 0);
			break;
		case 3:
			sbi(EICRA, 1);
			sbi(EICRA, 0);
			break;
		default:
			break;
		}
		
		return SUCCESS;
	}

	command result_t HALINTERRUPT.close(){
		cbi(EIMSK, 0);
		return SUCCESS;
	}

	command result_t HALINTERRUPT.read(){
		
		return SUCCESS;
	}

	command result_t HALINTERRUPT.write(uint8_t cmd){
		return SUCCESS;
	}

	command result_t HALINTERRUPT.ioctl(uint8_t data){
		return SUCCESS;
	}

	default async event result_t HALINTERRUPT.dataReady() { return FAIL;}

	TOSH_SIGNAL(SIG_INTERRUPT0){
		
		signal HALINTERRUPT.dataReady();
	}
}
