module HALINTR2M {
	provides {
		interface HALINTERRUPT;
	}
}

implementation {

	command result_t HALINTERRUPT.open(uint8_t enable){
		sbi(EIMSK, 2);

		switch(enable)
		{
		case 0:
			cbi(EICRA, 5);
			cbi(EICRA, 4);
			break;
		case 1:
			cbi(EICRA, 5);
			sbi(EICRA, 4);
			break;
		case 2:
			sbi(EICRA, 5);
			cbi(EICRA, 4);
			break;
		case 3:
			sbi(EICRA, 5);
			sbi(EICRA, 4);
			break;
		default:
			break;
		}
		
		return SUCCESS;
	}

	command result_t HALINTERRUPT.close(){
		cbi(EIMSK, 2);
		return SUCCESS;
	}

	command result_t HALINTERRUPT.read(){
		
		return SUCCESS;
	}

	command result_t HALINTERRUPT.write(uint8_t cmd){
		return SUCCESS;
	}

	command result_t HALINTERRUPT.ioctl(uint8_t data){
		return SUCCESS;
	}

	default async event result_t HALINTERRUPT.dataReady() { return FAIL;}

	TOSH_SIGNAL(SIG_INTERRUPT2){
		
		signal HALINTERRUPT.dataReady();
	}
}
