module HALINTR5M {
	provides {
		interface HALINTERRUPT;
	}
}

implementation {

	command result_t HALINTERRUPT.open(uint8_t enable){
		sbi(EIMSK, 5);

		switch(enable)
		{
		case 0:
			cbi(EICRB, 3);
			cbi(EICRB, 2);
			break;
		case 1:
			cbi(EICRB, 3);
			sbi(EICRB, 2);
			break;
		case 2:
			sbi(EICRB, 3);
			cbi(EICRB, 2);
			break;
		case 3:
			sbi(EICRB, 3);
			sbi(EICRB, 2);
			break;
		default:
			break;
		}
		
		return SUCCESS;
	}

	command result_t HALINTERRUPT.close(){
		cbi(EIMSK, 5);
		return SUCCESS;
	}

	command result_t HALINTERRUPT.read(){
		
		return SUCCESS;
	}

	command result_t HALINTERRUPT.write(uint8_t cmd){
		return SUCCESS;
	}

	command result_t HALINTERRUPT.ioctl(uint8_t data){
		return SUCCESS;
	}

	default async event result_t HALINTERRUPT.dataReady() { return FAIL;}

	TOSH_SIGNAL(SIG_INTERRUPT5){
		
		signal HALINTERRUPT.dataReady();
	}
}
