module HALINTR6M {
	provides {
		interface HALINTERRUPT;
	}
}

implementation {

	command result_t HALINTERRUPT.open(uint8_t enable){
		sbi(EIMSK, 6);

		switch(enable)
		{
		case 0:
			cbi(EICRB, 5);
			cbi(EICRB, 4);
			break;
		case 1:
			cbi(EICRB, 5);
			sbi(EICRB, 4);
			break;
		case 2:
			sbi(EICRB, 5);
			cbi(EICRB, 4);
			break;
		case 3:
			sbi(EICRB, 5);
			sbi(EICRB, 4);
			break;
		default:
			break;
		}
		
		return SUCCESS;
	}

	command result_t HALINTERRUPT.close(){
		cbi(EIMSK, 6);
		return SUCCESS;
	}

	command result_t HALINTERRUPT.read(){
		
		return SUCCESS;
	}

	command result_t HALINTERRUPT.write(uint8_t cmd){
		return SUCCESS;
	}

	command result_t HALINTERRUPT.ioctl(uint8_t data){
		return SUCCESS;
	}

	default async event result_t HALINTERRUPT.dataReady() { return FAIL;}

	TOSH_SIGNAL(SIG_INTERRUPT6){
		
		signal HALINTERRUPT.dataReady();
	}
}
