/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.bi.generator.source;

import com.softmeca.util.io.FileIoUtil;
import java.io.File;
import org.kldp.ebmsh.bi.generator.context.Context;
import org.kldp.ebmsh.bi.generator.context.Ejb2MDBContext;
import org.kldp.ebmsh.bi.generator.context.MDBContext;
import org.kldp.ebmsh.bi.generator.io.GeneratorIOException;
import org.kldp.ebmsh.bi.generator.io.SourceWriter;
import org.kldp.ebmsh.bi.generator.source.GeneratorSourceGeneratorException;
import org.kldp.ebmsh.bi.generator.source.MDBSourceGenerator;
import org.kldp.ebmsh.bi.generator.template.GeneratorTemplateException;
import org.kldp.ebmsh.bi.generator.template.TemplateEngine;

public class Ejb2MDBSourceGenerator
extends MDBSourceGenerator {
    private final String Ejb2MDBTemplateFileName = "Ejb2MDB.vm";
    private final String Ejb2ActionHandlerMDBOutputDirectory = "org" + File.separator + "kldp" + File.separator + "ebmsh" + File.separator + "bi" + File.separator + "actionhandler";

    public Ejb2MDBSourceGenerator(TemplateEngine templater) {
        super(templater);
    }

    public void generate(MDBContext mdbConetxt, String outputDirectory) throws GeneratorSourceGeneratorException {
        if (mdbConetxt == null) {
            throw new GeneratorSourceGeneratorException("mdbConetxt\ub294 null\uc77c \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        if (!(mdbConetxt instanceof Ejb2MDBContext)) {
            throw new GeneratorSourceGeneratorException("mdbConetxt\uc758 Type\uc774 Ejb2EjbJarContext\uc774 \uc544\ub2d9\ub2c8\ub2e4.");
        }
        this.generateSource(mdbConetxt, outputDirectory);
    }

    protected void generateSource(Context context, String outputDirectory) throws GeneratorSourceGeneratorException {
        Ejb2MDBContext actionHandlerContext = (Ejb2MDBContext)context;
        String ejb2ActionHandlerMDBSource = null;
        try {
            ejb2ActionHandlerMDBSource = this.templateEngine.merge("Ejb2MDB.vm", context);
        }
        catch (GeneratorTemplateException e) {
            throw new GeneratorSourceGeneratorException(e);
        }
        try {
            SourceWriter.getInstance().writeSource(ejb2ActionHandlerMDBSource, String.valueOf(FileIoUtil.fileSeparatorAddOrNone((String)outputDirectory)) + this.Ejb2ActionHandlerMDBOutputDirectory, String.valueOf(actionHandlerContext.getClassName()) + ".java");
        }
        catch (GeneratorIOException e) {
            throw new GeneratorSourceGeneratorException(e);
        }
    }
}

