/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.util.Collections;
import java.util.List;
import javax.xml.transform.Source;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public class XPathExpression {
    private XPathEvaluator evaluator;
    private Expression expression;
    private SlotManager stackFrameMap;
    static /* synthetic */ Class class$java$util$List;

    protected XPathExpression(XPathEvaluator xPathEvaluator, Expression expression) {
        this.expression = expression;
        this.evaluator = xPathEvaluator;
    }

    protected void setStackFrameMap(SlotManager slotManager) {
        this.stackFrameMap = slotManager;
    }

    public XPathContext createDynamicContext(Item item) {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(item, this.evaluator.getConfiguration());
        xPathContextMajor.openStackFrame(this.stackFrameMap);
        return xPathContextMajor;
    }

    public List evaluate(Source source) throws XPathException {
        NodeInfo nodeInfo = source instanceof NodeInfo ? (NodeInfo)source : this.evaluator.build(source);
        XPathContext xPathContext = this.createDynamicContext(nodeInfo);
        SequenceIterator sequenceIterator = this.expression.iterate(xPathContext);
        SequenceExtent sequenceExtent = new SequenceExtent(sequenceIterator);
        List list = (List)sequenceExtent.convertToJava(class$java$util$List == null ? (class$java$util$List = XPathExpression.class$("java.util.List")) : class$java$util$List, xPathContext);
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    public Object evaluateSingle(Source source) throws XPathException {
        SequenceIterator sequenceIterator = this.rawIterator(source);
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        return Value.convert(item);
    }

    public SequenceIterator rawIterator(Source source) throws XPathException {
        NodeInfo nodeInfo = source instanceof NodeInfo ? (NodeInfo)source : this.evaluator.build(source);
        XPathContext xPathContext = this.createDynamicContext(nodeInfo);
        SequenceIterator sequenceIterator = this.expression.iterate(xPathContext);
        return sequenceIterator;
    }

    public Expression getInternalExpression() {
        return this.expression;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

