/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.BEncoderStream;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.QDecoderStream;
import com.sun.mail.util.QEncoderStream;
import com.sun.mail.util.QPDecoderStream;
import com.sun.mail.util.QPEncoderStream;
import com.sun.mail.util.UUDecoderStream;
import com.sun.mail.util.UUEncoderStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.AsciiOutputStream;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MimeUtility {
    public static final int ALL = -1;
    private static String defaultJavaCharset;
    private static String defaultMIMECharset;
    private static Hashtable mime2java;
    private static Hashtable java2mime;
    static final int ALL_ASCII = 1;
    static final int MOSTLY_ASCII = 2;
    static final int MOSTLY_NONASCII = 3;
    static /* synthetic */ Class class$javax$mail$internet$MimeUtility;

    private MimeUtility() {
    }

    public static String getEncoding(DataSource dataSource) {
        ContentType contentType = null;
        InputStream inputStream = null;
        String string = null;
        try {
            contentType = new ContentType(dataSource.getContentType());
            inputStream = dataSource.getInputStream();
        }
        catch (Exception exception) {
            return "base64";
        }
        if (contentType.match("text/*")) {
            int n = MimeUtility.checkAscii(inputStream, -1, false);
            switch (n) {
                case 1: {
                    string = "7bit";
                    break;
                }
                case 2: {
                    string = "quoted-printable";
                    break;
                }
                default: {
                    string = "base64";
                    break;
                }
            }
        } else {
            string = MimeUtility.checkAscii(inputStream, -1, true) == 1 ? "7bit" : "base64";
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    static String getEncoding(DataHandler dataHandler) {
        ContentType contentType = null;
        String string = null;
        if (dataHandler.getName() != null) {
            return MimeUtility.getEncoding(dataHandler.getDataSource());
        }
        try {
            contentType = new ContentType(dataHandler.getContentType());
        }
        catch (Exception exception) {
            return "base64";
        }
        if (contentType.match("text/*")) {
            AsciiOutputStream asciiOutputStream = new AsciiOutputStream(false);
            try {
                dataHandler.writeTo((OutputStream)asciiOutputStream);
            }
            catch (IOException iOException) {}
            switch (asciiOutputStream.getAscii()) {
                case 1: {
                    string = "7bit";
                    break;
                }
                case 2: {
                    string = "quoted-printable";
                    break;
                }
                default: {
                    string = "base64";
                    break;
                }
            }
        } else {
            AsciiOutputStream asciiOutputStream = new AsciiOutputStream(true);
            try {
                dataHandler.writeTo((OutputStream)asciiOutputStream);
            }
            catch (IOException iOException) {}
            string = asciiOutputStream.getAscii() == 1 ? "7bit" : "base64";
        }
        return string;
    }

    public static InputStream decode(InputStream inputStream, String string) throws MessagingException {
        if (string.equalsIgnoreCase("base64")) {
            return new BASE64DecoderStream(inputStream);
        }
        if (string.equalsIgnoreCase("quoted-printable")) {
            return new QPDecoderStream(inputStream);
        }
        if (string.equalsIgnoreCase("uuencode") || string.equalsIgnoreCase("x-uuencode")) {
            return new UUDecoderStream(inputStream);
        }
        if (string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit")) {
            return inputStream;
        }
        throw new MessagingException("Unknown encoding: " + string);
    }

    public static OutputStream encode(OutputStream outputStream, String string) throws MessagingException {
        if (string == null) {
            return outputStream;
        }
        if (string.equalsIgnoreCase("base64")) {
            return new BASE64EncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("quoted-printable")) {
            return new QPEncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("uuencode") || string.equalsIgnoreCase("x-uuencode")) {
            return new UUEncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit")) {
            return outputStream;
        }
        throw new MessagingException("Unknown encoding: " + string);
    }

    public static String encodeText(String string) throws UnsupportedEncodingException {
        return MimeUtility.encodeText(string, null, null);
    }

    public static String encodeText(String string, String string2, String string3) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, string2, string3, false);
    }

    public static String decodeText(String string) throws UnsupportedEncodingException {
        String string2 = " \t\n\r";
        if (string.indexOf("=?") == -1) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            char c = string4.charAt(0);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                stringBuffer2.append(c);
                continue;
            }
            try {
                string3 = MimeUtility.decodeWord(string4);
                if (!bl && stringBuffer2.length() > 0) {
                    stringBuffer.append((Object)stringBuffer2);
                }
                bl = true;
            }
            catch (ParseException parseException) {
                string3 = string4;
                if (stringBuffer2.length() > 0) {
                    stringBuffer.append((Object)stringBuffer2);
                }
                bl = false;
            }
            stringBuffer.append(string3);
            stringBuffer2.setLength(0);
        }
        return stringBuffer.toString();
    }

    public static String encodeWord(String string) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, null, null);
    }

    public static String encodeWord(String string, String string2, String string3) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, string2, string3, true);
    }

    private static String encodeWord(String string, String string2, String string3, boolean bl) throws UnsupportedEncodingException {
        boolean bl2;
        String string4;
        if (MimeUtility.checkAscii(string) == 1) {
            return string;
        }
        if (string2 == null) {
            string4 = MimeUtility.getDefaultJavaCharset();
            string2 = MimeUtility.getDefaultMIMECharset();
        } else {
            string4 = MimeUtility.javaCharset(string2);
        }
        if (string3 == null) {
            byte[] byArray = string.getBytes(string4);
            string3 = MimeUtility.checkAscii(byArray) == 2 ? "Q" : "B";
        }
        if (string3.equalsIgnoreCase("B")) {
            bl2 = true;
        } else if (string3.equalsIgnoreCase("Q")) {
            bl2 = false;
        } else {
            throw new UnsupportedEncodingException("Unknown transfer encoding: " + string3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        MimeUtility.doEncode(string, bl2, string4, 68 - string2.length(), "=?" + string2 + "?" + string3 + "?", true, bl, stringBuffer);
        return stringBuffer.toString();
    }

    private static void doEncode(String string, boolean bl, String string2, int n, String string3, boolean bl2, boolean bl3, StringBuffer stringBuffer) throws UnsupportedEncodingException {
        int n2;
        byte[] byArray = string.getBytes(string2);
        int n3 = bl ? BEncoderStream.encodedLength(byArray) : QEncoderStream.encodedLength(byArray, bl3);
        if (n3 > n && (n2 = string.length()) > 1) {
            MimeUtility.doEncode(string.substring(0, n2 / 2), bl, string2, n, string3, bl2, bl3, stringBuffer);
            MimeUtility.doEncode(string.substring(n2 / 2, n2), bl, string2, n, string3, false, bl3, stringBuffer);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FilterOutputStream filterOutputStream = bl ? new BEncoderStream(byteArrayOutputStream) : new QEncoderStream((OutputStream)byteArrayOutputStream, bl3);
        try {
            ((OutputStream)filterOutputStream).write(byArray);
            ((OutputStream)filterOutputStream).close();
        }
        catch (IOException iOException) {}
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (!bl2) {
            stringBuffer.append("\r\n ");
        }
        stringBuffer.append(string3);
        int n4 = 0;
        while (n4 < byArray2.length) {
            stringBuffer.append((char)byArray2[n4]);
            ++n4;
        }
        stringBuffer.append("?=");
    }

    public static String decodeWord(String string) throws ParseException, UnsupportedEncodingException {
        if (!string.startsWith("=?")) {
            throw new ParseException();
        }
        int n = 2;
        int n2 = string.indexOf(63, n);
        if (n2 == -1) {
            throw new ParseException();
        }
        String string2 = MimeUtility.javaCharset(string.substring(n, n2));
        n = n2 + 1;
        if ((n2 = string.indexOf(63, n)) == -1) {
            throw new ParseException();
        }
        String string3 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf("?=", n)) == -1) {
            throw new ParseException();
        }
        String string4 = string.substring(n, n2);
        try {
            FilterInputStream filterInputStream;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ASCIIUtility.getBytes(string4));
            if (string3.equalsIgnoreCase("B")) {
                filterInputStream = new BASE64DecoderStream(byteArrayInputStream);
            } else if (string3.equalsIgnoreCase("Q")) {
                filterInputStream = new QDecoderStream(byteArrayInputStream);
            } else {
                throw new UnsupportedEncodingException("unknown encoding: " + string3);
            }
            int n3 = byteArrayInputStream.available();
            byte[] byArray = new byte[n3];
            n3 = ((InputStream)filterInputStream).read(byArray, 0, n3);
            return new String(byArray, 0, n3, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (IOException iOException) {
            throw new ParseException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException();
        }
    }

    public static String quote(String string, String string2) {
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\"' || c == '\\' || c == '\r' || c == '\n') {
                StringBuffer stringBuffer = new StringBuffer(n + 3);
                stringBuffer.append('\"');
                int n3 = 0;
                while (n3 < n) {
                    char c2 = string.charAt(n3);
                    if (c2 == '\"' || c2 == '\\' || c2 == '\r' || c2 == '\n') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c2);
                    ++n3;
                }
                stringBuffer.append('\"');
                return stringBuffer.toString();
            }
            if (c < ' ' || c >= '\u007f' || string2.indexOf(c) >= 0) {
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(n + 2);
            stringBuffer.append('\"').append(string).append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    public static String javaCharset(String string) {
        if (mime2java == null || string == null) {
            return string;
        }
        String string2 = (String)mime2java.get(string.toLowerCase());
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static String mimeCharset(String string) {
        if (java2mime == null || string == null) {
            return string;
        }
        String string2 = (String)java2mime.get(string.toLowerCase());
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static String getDefaultJavaCharset() {
        block2: {
            if (defaultJavaCharset != null) break block2;
            try {
                defaultJavaCharset = System.getProperty("file.encoding", "8859_1");
            }
            catch (SecurityException securityException) {
                InputStreamReader inputStreamReader = new InputStreamReader(new 1.NullInputStream());
                defaultJavaCharset = inputStreamReader.getEncoding();
                if (defaultJavaCharset != null) break block2;
                defaultJavaCharset = "8859_1";
            }
        }
        return defaultJavaCharset;
    }

    static String getDefaultMIMECharset() {
        if (defaultMIMECharset == null) {
            defaultMIMECharset = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
        }
        return defaultMIMECharset;
    }

    private static void loadMappings(LineInputStream lineInputStream, Hashtable hashtable) {
        while (true) {
            String string;
            try {
                string = lineInputStream.readLine();
            }
            catch (IOException iOException) {
                return;
            }
            if (string == null || string.startsWith("--") && string.endsWith("--")) break;
            if (string.trim().length() == 0 || string.startsWith("#")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
            try {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                hashtable.put(string2.toLowerCase(), string3);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    static int checkAscii(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) > '\u007f') {
                return 3;
            }
            ++n2;
        }
        return 1;
    }

    static int checkAscii(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            if ((byArray[n3] & 0xFF) > 127) {
                ++n2;
            } else {
                ++n;
            }
            ++n3;
        }
        if (n2 == 0) {
            return 1;
        }
        if (n > n2) {
            return 2;
        }
        return 3;
    }

    static int checkAscii(InputStream inputStream, int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 4096;
        int n5 = 0;
        boolean bl2 = false;
        byte[] byArray = null;
        if (n != 0) {
            n4 = n == -1 ? 4096 : Math.min(n, 4096);
            byArray = new byte[n4];
        }
        while (n != 0) {
            int n6;
            try {
                n6 = inputStream.read(byArray, 0, n4);
                if (n6 == -1) break;
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = byArray[n7] & 0xFF;
                    if (n8 == 13 || n8 == 10) {
                        n5 = 0;
                    } else if (++n5 > 998) {
                        bl2 = true;
                    }
                    if (n8 > 127) {
                        if (bl) {
                            return 3;
                        }
                        ++n3;
                    } else {
                        ++n2;
                    }
                    ++n7;
                }
            }
            catch (IOException iOException) {
                break;
            }
            if (n == -1) continue;
            n -= n6;
        }
        if (n == 0 && bl) {
            return 3;
        }
        if (n3 == 0) {
            if (bl2) {
                return 2;
            }
            return 1;
        }
        if (n2 > n3) {
            return 2;
        }
        return 3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        InputStream inputStream = (class$javax$mail$internet$MimeUtility != null ? class$javax$mail$internet$MimeUtility : (class$javax$mail$internet$MimeUtility = MimeUtility.class$("javax.mail.internet.MimeUtility"))).getResourceAsStream("/META-INF/javamail.charset.map");
        if (inputStream != null) {
            inputStream = new LineInputStream(inputStream);
            java2mime = new Hashtable(20);
            MimeUtility.loadMappings((LineInputStream)inputStream, java2mime);
            mime2java = new Hashtable(10);
            MimeUtility.loadMappings((LineInputStream)inputStream, mime2java);
        }
    }
}

