/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.moniter.persistant;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.moniter.persistant.DbTemplate;
import org.kldp.ebmsh.moniter.persistant.DbWorker;
import org.kldp.ebmsh.moniter.persistant.InComingMessage;
import org.kldp.ebmsh.moniter.persistant.MoniterPersistantException;

class IncomingMessageDAO {
    private static final Log log = LogFactory.getLog(IncomingMessageDAO.class);

    IncomingMessageDAO() {
    }

    InComingMessage getInComingMessage(String messageId) throws MoniterPersistantException {
        try {
            InComingMessage inComingMessage = null;
            DbTemplate dbTemplate = new DbTemplate();
            final String queryStr = "select * from " + EbmsConstants.bizboxDatabaseHeaderName + "InComingMessage where MessageId=?";
            final Object[] params = new Object[]{messageId};
            inComingMessage = (InComingMessage)dbTemplate.executeQuery(new DbWorker(){

                public Object work(Connection _conn) throws MoniterPersistantException {
                    QueryRunner runner = new QueryRunner();
                    BeanHandler resultSetHandler = new BeanHandler(InComingMessage.class);
                    InComingMessage queryResult = null;
                    try {
                        queryResult = (InComingMessage)runner.query(_conn, queryStr, params, (ResultSetHandler)resultSetHandler);
                    }
                    catch (SQLException e) {
                        throw new MoniterPersistantException(0, e.getErrorCode(), e);
                    }
                    return queryResult;
                }
            });
            return inComingMessage;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    List getInComingMessagesByPeriod(long startTime, long endTime, int pageCount) throws MoniterPersistantException {
        try {
            int perPageContentCount = 10;
            List inComingMessageInfoList = null;
            DbTemplate dbTemplate = new DbTemplate();
            int startCount = pageCount * perPageContentCount - 9;
            int endCount = startCount + 10;
            final Object[] params = new Object[]{new Timestamp(startTime), new Timestamp(endTime), new Integer(startCount), new Integer(endCount)};
            final String queryStr = "select * from (select /*+ index_desc(" + EbmsConstants.bizboxDatabaseHeaderName + "IncomingMessage idx_" + EbmsConstants.bizboxDatabaseHeaderName + "ReceiveTime) */ rownum as numrow, " + EbmsConstants.bizboxDatabaseHeaderName + "incomingmessage.* from " + EbmsConstants.bizboxDatabaseHeaderName + "incomingmessage where " + EbmsConstants.bizboxDatabaseHeaderName + "incomingmessage.ReceiveTime >= ? and " + EbmsConstants.bizboxDatabaseHeaderName + "incomingmessage.ReceiveTime <= ?" + ") where numrow >= ? and numrow < ?";
            inComingMessageInfoList = (List)dbTemplate.executeQuery(new DbWorker(){

                public Object work(Connection _conn) throws MoniterPersistantException {
                    QueryRunner runner = new QueryRunner();
                    BeanListHandler resultSetHandler = new BeanListHandler(InComingMessage.class);
                    List queryResult = null;
                    try {
                        queryResult = (List)runner.query(_conn, queryStr, params, (ResultSetHandler)resultSetHandler);
                    }
                    catch (SQLException e) {
                        throw new MoniterPersistantException(0, e.getErrorCode(), e);
                    }
                    return queryResult;
                }
            });
            return inComingMessageInfoList;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }

    long getInComingMessageCountByPeriod(long startTime, long endTime) throws MoniterPersistantException {
        try {
            long incomingMessageCount = 0L;
            BigDecimal incomingMessageCountBigDecimal = null;
            DbTemplate dbTemplate = new DbTemplate();
            final Object[] params = new Object[]{new Timestamp(startTime), new Timestamp(endTime)};
            final String queryStr = "select count(*) from " + EbmsConstants.bizboxDatabaseHeaderName + "IncomingMessage where ReceiveTime >= ? and ReceiveTime <= ?";
            incomingMessageCountBigDecimal = (BigDecimal)dbTemplate.executeQuery(new DbWorker(){

                public Object work(Connection _conn) throws MoniterPersistantException {
                    QueryRunner runner = new QueryRunner();
                    ScalarHandler resultSetHandler = new ScalarHandler();
                    BigDecimal queryResult = null;
                    try {
                        queryResult = (BigDecimal)runner.query(_conn, queryStr, params, (ResultSetHandler)resultSetHandler);
                    }
                    catch (SQLException e) {
                        throw new MoniterPersistantException(0, e.getErrorCode(), e);
                    }
                    return queryResult;
                }
            });
            if (incomingMessageCountBigDecimal != null) {
                incomingMessageCount = incomingMessageCountBigDecimal.longValue();
            }
            return incomingMessageCount;
        }
        catch (MoniterPersistantException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MoniterPersistantException(0, 0, e);
        }
    }
}

