/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.implementations;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class IntegrityHmac
extends SignatureAlgorithmSpi {
    static Log log = LogFactory.getLog((String)IntegrityHmacSHA1.class.getName());
    private Mac _macAlgorithm = null;
    int _HMACOutputLength = 0;

    public abstract String engineGetURI();

    public IntegrityHmac() throws XMLSignatureException {
        String algorithmID = JCEMapper.translateURItoJCEID(this.engineGetURI());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created IntegrityHmacSHA1 using " + algorithmID));
        }
        try {
            this._macAlgorithm = Mac.getInstance(algorithmID);
        }
        catch (NoSuchAlgorithmException ex) {
            Object[] exArgs = new Object[]{algorithmID, ex.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs);
        }
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws XMLSignatureException {
        throw new XMLSignatureException("empty");
    }

    public void reset() {
        this._HMACOutputLength = 0;
    }

    protected boolean engineVerify(byte[] signature) throws XMLSignatureException {
        try {
            byte[] completeResult = this._macAlgorithm.doFinal();
            if (this._HMACOutputLength == 0 || this._HMACOutputLength >= 160) {
                return MessageDigestAlgorithm.isEqual(completeResult, signature);
            }
            byte[] stripped = IntegrityHmac.reduceBitLength(completeResult, this._HMACOutputLength);
            return MessageDigestAlgorithm.isEqual(stripped, signature);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected void engineInitVerify(Key secretKey) throws XMLSignatureException {
        if (!(secretKey instanceof SecretKey)) {
            String supplied = secretKey.getClass().getName();
            String needed = SecretKey.class.getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            this._macAlgorithm.init(secretKey);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected byte[] engineSign() throws XMLSignatureException {
        try {
            byte[] completeResult = this._macAlgorithm.doFinal();
            if (this._HMACOutputLength == 0 || this._HMACOutputLength >= 160) {
                return completeResult;
            }
            return IntegrityHmac.reduceBitLength(completeResult, this._HMACOutputLength);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    private static byte[] reduceBitLength(byte[] completeResult, int length) {
        int bytes = length / 8;
        int abits = length % 8;
        byte[] strippedResult = new byte[bytes + (abits == 0 ? 0 : 1)];
        System.arraycopy(completeResult, 0, strippedResult, 0, bytes);
        if (abits > 0) {
            byte[] byArray = new byte[8];
            byArray[1] = -128;
            byArray[2] = -64;
            byArray[3] = -32;
            byArray[4] = -16;
            byArray[5] = -8;
            byArray[6] = -4;
            byArray[7] = -2;
            byte[] MASK = byArray;
            strippedResult[bytes] = (byte)(completeResult[bytes] & MASK[abits]);
        }
        return strippedResult;
    }

    protected void engineInitSign(Key secretKey) throws XMLSignatureException {
        if (!(secretKey instanceof SecretKey)) {
            String supplied = secretKey.getClass().getName();
            String needed = SecretKey.class.getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            this._macAlgorithm.init(secretKey);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected void engineInitSign(Key secretKey, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        if (!(secretKey instanceof SecretKey)) {
            String supplied = secretKey.getClass().getName();
            String needed = SecretKey.class.getName();
            Object[] exArgs = new Object[]{supplied, needed};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", exArgs);
        }
        try {
            this._macAlgorithm.init(secretKey, algorithmParameterSpec);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSignatureException("empty", ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected void engineInitSign(Key secretKey, SecureRandom secureRandom) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseSecureRandomOnMAC");
    }

    protected void engineUpdate(byte[] input) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(input);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected void engineUpdate(byte input) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(input);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected void engineUpdate(byte[] buf, int offset, int len) throws XMLSignatureException {
        try {
            this._macAlgorithm.update(buf, offset, len);
        }
        catch (IllegalStateException ex) {
            throw new XMLSignatureException("empty", ex);
        }
    }

    protected String engineGetJCEAlgorithmString() {
        log.debug((Object)"engineGetJCEAlgorithmString()");
        return this._macAlgorithm.getAlgorithm();
    }

    protected String engineGetJCEProviderName() {
        return this._macAlgorithm.getProvider().getName();
    }

    protected void engineSetHMACOutputLength(int HMACOutputLength) {
        this._HMACOutputLength = HMACOutputLength;
    }

    protected void engineGetContextFromElement(Element element) {
        super.engineGetContextFromElement(element);
        if (element == null) {
            throw new IllegalArgumentException("element null");
        }
        Text hmaclength = XMLUtils.selectDsNodeText(element.getFirstChild(), "HMACOutputLength", 0);
        if (hmaclength != null) {
            this._HMACOutputLength = Integer.parseInt(hmaclength.getData());
        }
    }

    public void engineAddContextToElement(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("null element");
        }
        if (this._HMACOutputLength != 0) {
            Document doc = element.getOwnerDocument();
            Element HMElem = XMLUtils.createElementInSignatureSpace(doc, "HMACOutputLength");
            Text HMText = doc.createTextNode(new Integer(this._HMACOutputLength).toString());
            HMElem.appendChild(HMText);
            XMLUtils.addReturnToElement(element);
            element.appendChild(HMElem);
            XMLUtils.addReturnToElement(element);
        }
    }

    public static class IntegrityHmacSHA1
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
        }
    }

    public static class IntegrityHmacSHA256
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
        }
    }

    public static class IntegrityHmacSHA384
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
        }
    }

    public static class IntegrityHmacSHA512
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
        }
    }

    public static class IntegrityHmacRIPEMD160
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160";
        }
    }

    public static class IntegrityHmacMD5
    extends IntegrityHmac {
        public String engineGetURI() {
            return "http://www.w3.org/2001/04/xmldsig-more#hmac-md5";
        }
    }
}

