/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.content.x509;

import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509DataContent;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509Certificate
extends SignatureElementProxy
implements XMLX509DataContent {
    public static final String JCA_CERT_ID = "X.509";

    public XMLX509Certificate(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public XMLX509Certificate(Document doc, byte[] certificateBytes) {
        super(doc);
        this.addBase64Text(certificateBytes);
    }

    public XMLX509Certificate(Document doc, X509Certificate x509certificate) throws XMLSecurityException {
        super(doc);
        try {
            this.addBase64Text(x509certificate.getEncoded());
        }
        catch (CertificateEncodingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public byte[] getCertificateBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public X509Certificate getX509Certificate() throws XMLSecurityException {
        try {
            byte[] certbytes = this.getCertificateBytes();
            CertificateFactory certFact = CertificateFactory.getInstance(JCA_CERT_ID);
            X509Certificate cert = (X509Certificate)certFact.generateCertificate(new ByteArrayInputStream(certbytes));
            if (cert != null) {
                return cert;
            }
            return null;
        }
        catch (CertificateException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public PublicKey getPublicKey() throws XMLSecurityException {
        X509Certificate cert = this.getX509Certificate();
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().getName().equals(obj.getClass().getName())) {
            return false;
        }
        XMLX509Certificate other = (XMLX509Certificate)obj;
        try {
            return MessageDigest.isEqual(other.getCertificateBytes(), this.getCertificateBytes());
        }
        catch (XMLSecurityException ex) {
            return false;
        }
    }

    public int hashCode() {
        return 72;
    }

    public String getBaseLocalName() {
        return "X509Certificate";
    }
}

