/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.util.HashMap;
import java.util.Stack;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;

class DispatchHandler
implements ElementHandler {
    private boolean atRoot = true;
    private String path = "/";
    private Stack pathStack = new Stack();
    private Stack handlerStack = new Stack();
    private HashMap handlers = new HashMap();
    private ElementHandler defaultHandler;

    public void addHandler(String path, ElementHandler handler) {
        this.handlers.put(path, handler);
    }

    public String getPath() {
        return this.path;
    }

    public void onEnd(ElementPath elementPath) {
        if (this.handlers != null && this.handlers.containsKey(this.path)) {
            ElementHandler handler = (ElementHandler)this.handlers.get(this.path);
            this.handlerStack.pop();
            handler.onEnd(elementPath);
        } else if (this.handlerStack.isEmpty() && this.defaultHandler != null) {
            this.defaultHandler.onEnd(elementPath);
        }
        this.path = (String)this.pathStack.pop();
    }

    public void onStart(ElementPath elementPath) {
        Element element = elementPath.getCurrent();
        this.pathStack.push(this.path);
        if (this.atRoot) {
            this.path = String.valueOf(this.path) + element.getName();
            this.atRoot = false;
        } else {
            this.path = String.valueOf(this.path) + "/" + element.getName();
        }
        if (this.handlers != null && this.handlers.containsKey(this.path)) {
            ElementHandler handler = (ElementHandler)this.handlers.get(this.path);
            this.handlerStack.push(handler);
            handler.onStart(elementPath);
        } else if (this.handlerStack.isEmpty() && this.defaultHandler != null) {
            this.defaultHandler.onStart(elementPath);
        }
    }

    public ElementHandler removeHandler(String path) {
        return (ElementHandler)this.handlers.remove(path);
    }

    public void setDefaultHandler(ElementHandler handler) {
        this.defaultHandler = handler;
    }
}

