/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.util.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.kldp.util.xml.XmlParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlParserUtil {
    private DocumentBuilderFactory documentBuilderFactory = null;
    private DocumentBuilder documentBuilder = null;
    private Document document = null;
    private Element rootElement = null;

    private XmlParserUtil() {
    }

    public XmlParserUtil(File _xmlFile) throws XmlParserException {
        try {
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilderFactory.setNamespaceAware(true);
            this.documentBuilderFactory.setIgnoringComments(true);
            this.documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            this.document = this.documentBuilder.parse(_xmlFile);
            this.rootElement = this.document.getDocumentElement();
        }
        catch (SAXException e) {
            throw new XmlParserException("Parsing \uc2e4\ud328");
        }
        catch (ParserConfigurationException e) {
            throw new XmlParserException("Parsing \uc2e4\ud328");
        }
        catch (IOException e) {
            throw new XmlParserException("Parsing \uc2e4\ud328");
        }
    }

    public XmlParserUtil(InputStream _xmlStream) throws XmlParserException {
        try {
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilderFactory.setNamespaceAware(true);
            this.documentBuilderFactory.setIgnoringComments(true);
            this.documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            this.document = this.documentBuilder.parse(_xmlStream);
            this.rootElement = this.document.getDocumentElement();
        }
        catch (SAXException e) {
            throw new XmlParserException("Parsing \uc2e4\ud328");
        }
        catch (ParserConfigurationException e) {
            throw new XmlParserException("Parsing \uc2e4\ud328");
        }
        catch (IOException e) {
            throw new XmlParserException("Parsing \uc2e4\ud328");
        }
    }

    public Element getElement(String _elementName) throws XmlParserException {
        Node element = null;
        NodeList nodeList = this.rootElement.getElementsByTagName(_elementName);
        element = nodeList.item(0);
        if (element == null) {
            throw new XmlParserException(String.valueOf(_elementName) + " \uc5d8\ub9ac\uba3c\ud2b8\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        return (Element)element;
    }

    public Element getElement(String _elementName, String _namespace) throws XmlParserException {
        Node element = null;
        NodeList nodeList = this.rootElement.getElementsByTagNameNS(_elementName, _namespace);
        element = nodeList.item(0);
        if (element == null) {
            throw new XmlParserException(String.valueOf(_elementName) + " \uc5d8\ub9ac\uba3c\ud2b8\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        return (Element)element;
    }

    public String getElementValue(String _elementName) throws XmlParserException {
        String value = null;
        try {
            Element node = this.getElement(_elementName);
            Node firstNode = node.getFirstChild();
            value = firstNode.getNodeValue();
        }
        catch (NullPointerException e) {
            throw new XmlParserException(String.valueOf(_elementName) + " \uc5d8\ub9ac\uba3c\ud2b8\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        return value;
    }

    public String getElementValue(String _elementName, String _namespace) throws XmlParserException {
        String value = null;
        try {
            Element node = this.getElement(_elementName, _namespace);
            Node firstNode = node.getFirstChild();
            value = firstNode.getNodeValue();
        }
        catch (NullPointerException e) {
            throw new XmlParserException(String.valueOf(_elementName) + " \uc5d8\ub9ac\uba3c\ud2b8\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        return value;
    }

    public String getAttributeValue(String _elementName, String _attributeName) throws XmlParserException {
        String value = null;
        Element element = this.getElement(_elementName);
        value = element.getAttribute(_attributeName);
        if (value == null || value.equals("")) {
            throw new XmlParserException(String.valueOf(_attributeName) + " \uc18d\uc131\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        return value;
    }

    public String getAttributeValue(String _elementName, String _elementNamespace, String _attributeName, String _attributeNamespace) throws XmlParserException {
        String value = null;
        Element element = this.getElement(_elementName, _elementNamespace);
        value = element.getAttributeNS(_attributeName, _attributeNamespace);
        if (value == null || value.equals("")) {
            throw new XmlParserException(String.valueOf(_attributeName) + " \uc18d\uc131\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        return value;
    }
}

