/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.cpa;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.XmlBase64Binary;
import org.apache.xmlbeans.XmlDuration;
import org.apache.xmlbeans.XmlObject;
import org.kldp.ebmsh.cpa.CanReceive;
import org.kldp.ebmsh.cpa.CanSend;
import org.kldp.ebmsh.cpa.Certificate;
import org.kldp.ebmsh.cpa.Cpa;
import org.kldp.ebmsh.cpa.DeliveryChannel;
import org.kldp.ebmsh.cpa.EbmsCpaException;
import org.kldp.ebmsh.cpa.MessagingCharacteristics;
import org.kldp.ebmsh.cpa.NonRepudiation;
import org.kldp.ebmsh.cpa.ReceiverNonRepudiation;
import org.kldp.ebmsh.cpa.ReliableMessaging;
import org.kldp.ebmsh.cpa.SenderNonRepudiation;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.ActionBindingType;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.ActorType;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.BusinessTransactionCharacteristicsDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.CanReceiveDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.CanSendDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.CertificateDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.CertificateRefType;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.ChannelIdDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.CollaborationRoleDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.DeliveryChannelDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.DocExchangeDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.EbXMLReceiverBindingDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.EbXMLSenderBindingDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.EndpointDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.EndpointTypeType;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.MessageOrderSemanticsType;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.MessagingCharacteristicsDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.PartyIdDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.PartyInfoDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.PartyRefDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.PerMessageCharacteristicsType;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.ProtocolType;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.ReceiverNonRepudiationDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.ReliableMessagingDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.RoleDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.SecurityDetailsDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.SecurityDetailsRefType;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.SenderNonRepudiationDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.ServiceType;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.SignatureAlgorithmDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.SyncReplyModeType;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.TransportClientSecurityDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.TransportDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.TransportReceiverDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.TransportSenderDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.TransportServerSecurityDocument;
import org.oasisOpen.committees.ebxmlCppa.schema.cppCpa20.TrustAnchorsDocument;
import org.w3.x2000.x09.xmldsig.KeyInfoType;
import org.w3.x2000.x09.xmldsig.X509DataType;
import sun.misc.BASE64Encoder;

public class PartyInfo
extends Cpa {
    private PartyInfoDocument.PartyInfo partyInfo = null;

    public PartyInfo(PartyInfoDocument.PartyInfo partyInfo) {
        this.partyInfo = partyInfo;
    }

    public void setPartyName(String _partyName) throws EbmsCpaException {
        try {
            this.partyInfo.setPartyName(_partyName);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String getPartyName() throws EbmsCpaException {
        try {
            return this.partyInfo.getPartyName();
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setDefaultMshChannelId(String _id) throws EbmsCpaException {
        try {
            this.partyInfo.setDefaultMshPackageId(_id);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String getDefaultMshChannelId() throws EbmsCpaException {
        try {
            return this.partyInfo.getDefaultMshChannelId();
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setDefaultMshPackageId(String _id) throws EbmsCpaException {
        try {
            this.partyInfo.setDefaultMshPackageId(_id);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String getDefaultMshPackageId(String _id) throws EbmsCpaException {
        try {
            return this.partyInfo.getDefaultMshPackageId();
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public PartyIdDocument.PartyId addPartyId(String _type, String _value) throws EbmsCpaException {
        try {
            PartyIdDocument.PartyId partyId = this.partyInfo.addNewPartyId();
            partyId.setType(_type);
            partyId.setStringValue(_value);
            return partyId;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setPartyId(int _seq, String _type, String _value) throws EbmsCpaException {
        try {
            PartyIdDocument.PartyId partyId = this.partyInfo.getPartyIdArray(_seq);
            if (_type != null) {
                partyId.setType(_type);
            }
            if (_value != null) {
                partyId.setStringValue(_value);
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String getPartyId(int _seq, String _value) throws EbmsCpaException {
        try {
            return this.partyInfo.getPartyIdArray(_seq).getStringValue();
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String getPartyIdType(int _seq) throws EbmsCpaException {
        try {
            return this.partyInfo.getPartyIdArray(_seq).getType();
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public PartyRefDocument.PartyRef addPartyRef(String _type, String _href) throws EbmsCpaException {
        try {
            PartyRefDocument.PartyRef partyRef = this.partyInfo.addNewPartyRef();
            partyRef.setType2(_type);
            partyRef.setHref(_href);
            return partyRef;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setPartyRef(int _seq, String _type, String _href) throws EbmsCpaException {
        try {
            PartyRefDocument.PartyRef partyRef = this.partyInfo.getPartyRefArray(_seq);
            if (_type != null) {
                partyRef.setType2(_type);
            }
            if (_href != null) {
                partyRef.setHref(_href);
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void getPartyRef() throws EbmsCpaException {
    }

    public void addService() throws EbmsCpaException {
    }

    public void setService(String _type, String _name) throws EbmsCpaException {
        try {
            ServiceType serviceType = this.partyInfo.getCollaborationRoleArray()[0].getServiceBinding().getService();
            if (_type != null) {
                serviceType.setType(_type);
            }
            if (_name != null) {
                serviceType.setStringValue(_name);
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String getService() throws EbmsCpaException {
        try {
            return this.partyInfo.getCollaborationRoleArray()[0].getServiceBinding().getService().getStringValue();
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String getServiceType() throws EbmsCpaException {
        try {
            return this.partyInfo.getCollaborationRoleArray()[0].getServiceBinding().getService().getType();
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public CanSend addCanSend(String _bindingId, String _action, String _packageId, String[] _channelId, String _otherPartyActionBinding) throws EbmsCpaException {
        try {
            CanSendDocument.CanSend canSend = this.partyInfo.getCollaborationRoleArray(0).getServiceBinding().addNewCanSend();
            ActionBindingType actionBindingType = canSend.addNewThisPartyActionBinding();
            actionBindingType.setId(_bindingId);
            actionBindingType.setAction(_action);
            actionBindingType.setPackageId(_packageId);
            BusinessTransactionCharacteristicsDocument.BusinessTransactionCharacteristics businessTransactionCharacteristics = actionBindingType.addNewBusinessTransactionCharacteristics();
            businessTransactionCharacteristics.setIsNonRepudiationRequired(false);
            businessTransactionCharacteristics.setIsNonRepudiationReceiptRequired(false);
            int i = 0;
            while (i < _channelId.length) {
                actionBindingType.addChannelId(_channelId[i]);
                ++i;
            }
            canSend.setOtherPartyActionBinding(_otherPartyActionBinding);
            return new CanSend(canSend);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setCanSend(String _oldActionBindingId, String _newActionBindingId, String _action, String _packageId, int _channelIdSeq, String _channelId, String _otherPartyActionBinding) throws EbmsCpaException {
        try {
            CanSend[] canSends = this.getCanSends();
            int i = 0;
            while (i < canSends.length) {
                if (canSends[i].getBindingId().equals(_oldActionBindingId)) {
                    if (_newActionBindingId != null) {
                        this.setAttribute(_oldActionBindingId, _newActionBindingId);
                    }
                    if (_action != null) {
                        canSends[i].setAction(_action);
                    }
                    if (_packageId != null) {
                        canSends[i].setPackageId(_packageId);
                    }
                    if (_channelId != null) {
                        canSends[i].setChannelId(_channelIdSeq, _channelId);
                    }
                    if (_otherPartyActionBinding != null) {
                        canSends[i].setOtherPartyActionBinding(_otherPartyActionBinding);
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public CanSend[] getCanSends() throws EbmsCpaException {
        try {
            CanSend[] canSend = null;
            CollaborationRoleDocument.CollaborationRole collaborationRole = null;
            CanSendDocument.CanSend[] canSend_ = null;
            collaborationRole = this.partyInfo.getCollaborationRoleArray()[0];
            canSend_ = collaborationRole.getServiceBinding().getCanSendArray();
            canSend = new CanSend[canSend_.length];
            int i = 0;
            while (i < canSend.length) {
                canSend[i] = new CanSend(canSend_[i]);
                ++i;
            }
            return canSend;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public CanSend getCanSend(String _action) throws EbmsCpaException {
        try {
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "']/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend[tp:ThisPartyActionBinding[@tp:action='" + _action + "']]";
            CanSendDocument.CanSend[] result_canSends = (CanSendDocument.CanSend[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
            return new CanSend(result_canSends[0]);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public CanReceive addCanReceive(String _bindingId, String _action, String _packageId, String[] _channelId, String _otherPartyActionBinding) throws EbmsCpaException {
        try {
            CanReceiveDocument.CanReceive canReceive = this.partyInfo.getCollaborationRoleArray(0).getServiceBinding().addNewCanReceive();
            ActionBindingType actionBindingType = canReceive.addNewThisPartyActionBinding();
            actionBindingType.setId(_bindingId);
            actionBindingType.setAction(_action);
            actionBindingType.setPackageId(_packageId);
            BusinessTransactionCharacteristicsDocument.BusinessTransactionCharacteristics businessTransactionCharacteristics = actionBindingType.addNewBusinessTransactionCharacteristics();
            businessTransactionCharacteristics.setIsNonRepudiationRequired(false);
            businessTransactionCharacteristics.setIsNonRepudiationReceiptRequired(false);
            int i = 0;
            while (i < _channelId.length) {
                actionBindingType.addChannelId(_channelId[i]);
                ++i;
            }
            canReceive.setOtherPartyActionBinding(_otherPartyActionBinding);
            return new CanReceive(canReceive);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setCanReceive(String _oldActionBindingId, String _newActionBindingId, String _action, String _packageId, int _channelIdSeq, String _channelId, String _otherPartyActionBinding) throws EbmsCpaException {
        try {
            CanReceive[] CanReceive2 = this.getCanReceives();
            int i = 0;
            while (i < CanReceive2.length) {
                if (CanReceive2[i].getBindingId().equals(_oldActionBindingId)) {
                    if (_newActionBindingId != null) {
                        this.setAttribute(_oldActionBindingId, _newActionBindingId);
                    }
                    if (_action != null) {
                        CanReceive2[i].setAction(_action);
                    }
                    if (_packageId != null) {
                        CanReceive2[i].setPackageId(_packageId);
                    }
                    if (_channelId != null) {
                        CanReceive2[i].setChannelId(_channelIdSeq, _channelId);
                    }
                    if (_otherPartyActionBinding != null) {
                        CanReceive2[i].setOtherPartyActionBinding(_otherPartyActionBinding);
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public CanReceive[] getCanReceives() throws EbmsCpaException {
        try {
            CanReceive[] canReceive = null;
            CollaborationRoleDocument.CollaborationRole collaborationRole = null;
            CanReceiveDocument.CanReceive[] canReceive_ = null;
            collaborationRole = this.partyInfo.getCollaborationRoleArray()[0];
            canReceive_ = collaborationRole.getServiceBinding().getCanReceiveArray();
            canReceive = new CanReceive[canReceive_.length];
            int i = 0;
            while (i < canReceive.length) {
                canReceive[i] = new CanReceive(canReceive_[i]);
                ++i;
            }
            return canReceive;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public CanReceive getCanReceive(String _action) throws EbmsCpaException {
        try {
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:CollaborationRole/tp:ServiceBinding/tp:CanReceive[tp:ThisPartyActionBinding[@tp:action='" + _action + "']]";
            CanReceiveDocument.CanReceive[] result_canReceives = (CanReceiveDocument.CanReceive[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
            return new CanReceive(result_canReceives[0]);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public Certificate addCertificate(String _certId, String[] _keyName, String _x509Certificate) throws EbmsCpaException {
        try {
            CertificateDocument.Certificate certificate = this.partyInfo.addNewCertificate();
            certificate.setCertId(_certId);
            KeyInfoType keyInfoType = certificate.addNewKeyInfo();
            int i = 0;
            while (i < _keyName.length) {
                keyInfoType.addNewKeyName().setStringValue(_keyName[i]);
                ++i;
            }
            if (_x509Certificate != null) {
                X509DataType x509DataType = keyInfoType.addNewX509Data();
                XmlBase64Binary xmlBase64Binary = x509DataType.addNewX509Certificate();
                BASE64Encoder encoder = new BASE64Encoder();
                String base64 = encoder.encode(_x509Certificate.getBytes());
                xmlBase64Binary.setStringValue(base64);
            }
            return new Certificate(certificate);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setCertificate(String _oldCertId, String _newCertId, int _keySeq, String _keyName, int _certSeq, String _x509Certificate) throws EbmsCpaException {
        try {
            Certificate certificate = this.getCertificate(_oldCertId);
            if (_newCertId != null) {
                this.setAttribute(_oldCertId, _newCertId);
            }
            if (_keyName != null) {
                certificate.setKeyName(_keySeq, _keyName);
            }
            if (_x509Certificate != null && _certSeq >= certificate.getX509Certificate().length) {
                certificate.setX509Certificate(_certSeq, _x509Certificate);
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public Certificate[] getCertificates() throws EbmsCpaException {
        try {
            Certificate[] resultCertificate = null;
            CertificateDocument.Certificate[] certificateArray = this.partyInfo.getCertificateArray();
            if (certificateArray.length != 0) {
                resultCertificate = new Certificate[certificateArray.length];
                int i = 0;
                while (i < certificateArray.length) {
                    resultCertificate[i] = new Certificate(certificateArray[i]);
                    ++i;
                }
            }
            return resultCertificate;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public Certificate getCertificate(String _certId) throws EbmsCpaException {
        try {
            Certificate resultCertificate = null;
            CertificateDocument.Certificate[] certificateArray = this.partyInfo.getCertificateArray();
            int i = 0;
            while (i < certificateArray.length) {
                if (certificateArray[i].getCertId().equals(_certId)) {
                    resultCertificate = new Certificate(certificateArray[i]);
                    break;
                }
                ++i;
            }
            return resultCertificate;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public SecurityDetailsDocument.SecurityDetails addSecurityDetailswithTrustAnchors(String _securityId, String _certId) throws EbmsCpaException {
        try {
            SecurityDetailsDocument.SecurityDetails securityDetails = this.partyInfo.addNewSecurityDetails();
            securityDetails.setSecurityId(_securityId);
            TrustAnchorsDocument.TrustAnchors trustAnchors = securityDetails.addNewTrustAnchors();
            CertificateRefType certificateRefType = trustAnchors.addNewAnchorCertificateRef();
            certificateRefType.setCertId(_certId);
            return securityDetails;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setSecurityDetailswithTrustAnchors(String _oldSecurityId, String _newSecurityId, int _certSeq, String _certId) throws EbmsCpaException {
        try {
            SecurityDetailsDocument.SecurityDetails[] securityDetails = this.partyInfo.getSecurityDetailsArray();
            int i = 0;
            while (i < securityDetails.length) {
                if (securityDetails[i].getSecurityId().equals(_oldSecurityId) && _newSecurityId != null) {
                    this.setAttribute(_oldSecurityId, _newSecurityId);
                    if (_certId != null) {
                        CertificateRefType certificateRefType = CertificateRefType.Factory.newInstance();
                        certificateRefType.setCertId(_certId);
                        securityDetails[i].getTrustAnchors().setAnchorCertificateRefArray(_certSeq, certificateRefType);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String[] getSecurityDetailsIds() throws EbmsCpaException {
        try {
            String[] resultSecurityDetailsIds = null;
            SecurityDetailsDocument.SecurityDetails[] securityDetails = this.partyInfo.getSecurityDetailsArray();
            if (resultSecurityDetailsIds.length != 0) {
                resultSecurityDetailsIds = new String[securityDetails.length];
                int i = 0;
                while (i < resultSecurityDetailsIds.length) {
                    resultSecurityDetailsIds[i] = securityDetails[i].getSecurityId();
                    ++i;
                }
            }
            return resultSecurityDetailsIds;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String[] getSecurityDetailsTrustAnchorsCertIds(String _securityId) throws EbmsCpaException {
        try {
            String[] resultSecurityDetailsTrustAnchorsCertIds = null;
            SecurityDetailsDocument.SecurityDetails[] securityDetails = this.partyInfo.getSecurityDetailsArray();
            int i = 0;
            while (i < securityDetails.length) {
                CertificateRefType[] crt;
                if (securityDetails[i].getSecurityId().equals(_securityId) && (crt = securityDetails[i].getTrustAnchors().getAnchorCertificateRefArray()).length != 0) {
                    resultSecurityDetailsTrustAnchorsCertIds = new String[crt.length];
                    int j = 0;
                    while (j < crt.length) {
                        resultSecurityDetailsTrustAnchorsCertIds[j] = crt[j].getCertId();
                        ++j;
                    }
                }
                ++i;
            }
            return resultSecurityDetailsTrustAnchorsCertIds;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public DeliveryChannelDocument.DeliveryChannel addDeliveryChannelWithMessagingCharacteristics(String _channelId, String _transportId, String _docExchangeId, SyncReplyModeType.Enum _syncReplyMode, PerMessageCharacteristicsType.Enum _ackRequested, PerMessageCharacteristicsType.Enum _ackSignatureRequested, PerMessageCharacteristicsType.Enum _duplicateElimination, ActorType.Enum _actor) throws EbmsCpaException {
        try {
            DeliveryChannelDocument.DeliveryChannel deliveryChannel = this.partyInfo.addNewDeliveryChannel();
            deliveryChannel.setChannelId(_channelId);
            deliveryChannel.setTransportId(_transportId);
            deliveryChannel.setDocExchangeId(_docExchangeId);
            MessagingCharacteristicsDocument.MessagingCharacteristics messagingCharacteristics = deliveryChannel.addNewMessagingCharacteristics();
            messagingCharacteristics.setSyncReplyMode(_syncReplyMode);
            messagingCharacteristics.setAckRequested(_ackRequested);
            messagingCharacteristics.setAckSignatureRequested(_ackSignatureRequested);
            messagingCharacteristics.setDuplicateElimination(_duplicateElimination);
            messagingCharacteristics.setActor(_actor);
            return deliveryChannel;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setTransportIdUnderDeliveryChannel(String _action, String _transportId) throws EbmsCpaException {
        try {
            String channelId = null;
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "'] where $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding[@tp:action='" + _action + "'] return $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding/tp:ChannelId";
            ChannelIdDocument[] results_channelId = (ChannelIdDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            channelId = results_channelId[0].getChannelId();
            pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:DeliveryChannel[@tp:channelId='" + channelId + "']";
            DeliveryChannelDocument.DeliveryChannel[] results_deliveryChannel = (DeliveryChannelDocument.DeliveryChannel[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
            results_deliveryChannel[0].setTransportId(_transportId);
            System.out.println(results_deliveryChannel[0].getTransportId());
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String[] getDeliveryChannelIds() throws EbmsCpaException {
        try {
            String[] deliveryChannelId = null;
            DeliveryChannelDocument.DeliveryChannel[] deliveryChannel = this.partyInfo.getDeliveryChannelArray();
            deliveryChannelId = new String[deliveryChannel.length];
            int i = 0;
            while (i < deliveryChannel.length) {
                deliveryChannelId[i] = deliveryChannel[i].getChannelId();
                ++i;
            }
            return deliveryChannelId;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public DeliveryChannel getDeliveryChannel(String _channelId) throws EbmsCpaException {
        try {
            DeliveryChannelDocument.DeliveryChannel[] deliveryChannel = this.partyInfo.getDeliveryChannelArray();
            int i = 0;
            while (i < deliveryChannel.length) {
                if (deliveryChannel[i].getChannelId().equals(_channelId)) {
                    return new DeliveryChannel(deliveryChannel[i]);
                }
                ++i;
            }
            return null;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public DeliveryChannel[] getDeliveryChannels() throws EbmsCpaException {
        try {
            DeliveryChannel[] deliveryChannelArray = null;
            DeliveryChannelDocument.DeliveryChannel[] deliveryChannel = this.partyInfo.getDeliveryChannelArray();
            deliveryChannelArray = new DeliveryChannel[deliveryChannel.length];
            int i = 0;
            while (i < deliveryChannel.length) {
                deliveryChannelArray[i] = new DeliveryChannel(deliveryChannel[i]);
                ++i;
            }
            return deliveryChannelArray;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public DeliveryChannel getDeliveryChannelByAction(String _action) throws EbmsCpaException {
        try {
            CanSend canSend = this.getCanSend(_action);
            if (canSend != null) {
                String channelId = canSend.getChannelIds()[0];
                return this.getDeliveryChannel(channelId);
            }
            CanReceive canReceive = this.getCanReceive(_action);
            if (canReceive != null) {
                String channelId = canReceive.getChannelIds()[0];
                return this.getDeliveryChannel(channelId);
            }
            return null;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setMessagingCharacteristicsUnderDocExchange(PerMessageCharacteristicsType.Enum _ackRequested, PerMessageCharacteristicsType.Enum _ackSignatureRequested, SyncReplyModeType.Enum _syncReplyMode, PerMessageCharacteristicsType.Enum _duplicateElimination, ActorType.Enum _actor) throws EbmsCpaException {
        try {
            MessagingCharacteristics messagingCharacteristics = this.getMessagingCharacteristics();
            if (_ackRequested != null) {
                messagingCharacteristics.setAckRequested(_ackRequested);
            }
            if (_ackSignatureRequested != null) {
                messagingCharacteristics.setAckSignatureRequested(_ackSignatureRequested);
            }
            if (_syncReplyMode != null) {
                messagingCharacteristics.setSyncReplyMode(_syncReplyMode);
            }
            if (_duplicateElimination != null) {
                messagingCharacteristics.setDuplicateElimination(_duplicateElimination);
            }
            if (_actor != null) {
                messagingCharacteristics.setActor(_actor);
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public MessagingCharacteristics getMessagingCharacteristics(String _action) throws EbmsCpaException {
        try {
            Object messagingCharacteristics = null;
            String channelId = null;
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "'] where $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding[@tp:action='" + _action + "'] return $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding/tp:ChannelId";
            ChannelIdDocument[] results_channelId = (ChannelIdDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            channelId = results_channelId[0].getChannelId();
            pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:DeliveryChannel[@tp:channelId='" + channelId + "']/tp:MessagingCharacteristics";
            MessagingCharacteristicsDocument.MessagingCharacteristics[] result_messagingCharacteristics = (MessagingCharacteristicsDocument.MessagingCharacteristics[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
            return new MessagingCharacteristics(result_messagingCharacteristics[0]);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public MessagingCharacteristics getMessagingCharacteristics() throws EbmsCpaException {
        try {
            MessagingCharacteristics messagingCharacteristics = null;
            MessagingCharacteristicsDocument.MessagingCharacteristics messagingCharacteristics_ = null;
            DeliveryChannelDocument.DeliveryChannel[] deliveryChannel = null;
            String defaultChannelId = null;
            defaultChannelId = this.partyInfo.getDefaultMshChannelId();
            deliveryChannel = this.partyInfo.getDeliveryChannelArray();
            int i = 0;
            while (i < deliveryChannel.length) {
                if (defaultChannelId.equals(deliveryChannel[i].getChannelId())) {
                    messagingCharacteristics_ = deliveryChannel[i].getMessagingCharacteristics();
                    messagingCharacteristics = new MessagingCharacteristics(messagingCharacteristics_);
                    break;
                }
                ++i;
            }
            return messagingCharacteristics;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public TransportDocument.Transport addTransport(String _transportId, String _senderProtocol, String _receiverProtocol, String _uri) throws EbmsCpaException {
        try {
            TransportDocument.Transport transport = this.partyInfo.addNewTransport();
            transport.setTransportId(_transportId);
            TransportSenderDocument.TransportSender transportSender = transport.addNewTransportSender();
            transportSender.addNewTransportProtocol().setStringValue(_senderProtocol);
            TransportReceiverDocument.TransportReceiver transportReceiver = transport.addNewTransportReceiver();
            transportReceiver.addNewTransportProtocol().setStringValue(_receiverProtocol);
            EndpointDocument.Endpoint endpoint = transportReceiver.addNewEndpoint();
            endpoint.setType(EndpointTypeType.ALL_PURPOSE);
            endpoint.setUri(_uri);
            return transport;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setTransport(String _oldTransportId, String _newTransportId, String _senderProtocol, String _receiverProtocol, int _endpointSeq, String _uri) throws EbmsCpaException {
        try {
            TransportDocument.Transport[] transports = this.partyInfo.getTransportArray();
            int i = 0;
            while (i < transports.length) {
                if (transports[i].getTransportId().equals(_oldTransportId)) {
                    ProtocolType pt;
                    if (_newTransportId != null) {
                        this.setAttribute(_oldTransportId, _newTransportId);
                    }
                    if (_senderProtocol != null) {
                        pt = ProtocolType.Factory.newInstance();
                        pt.setStringValue(_senderProtocol);
                        transports[i].getTransportSender().setTransportProtocol(pt);
                    }
                    if (_receiverProtocol != null) {
                        pt = ProtocolType.Factory.newInstance();
                        pt.setStringValue(_receiverProtocol);
                        EndpointDocument.Endpoint endpoint = EndpointDocument.Endpoint.Factory.newInstance();
                        endpoint.setUri(_uri);
                        transports[i].getTransportReceiver().setTransportProtocol(pt);
                        transports[i].getTransportReceiver().setEndpointArray(_endpointSeq, endpoint);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String[] getTranportIds() throws EbmsCpaException {
        try {
            String[] transport = null;
            TransportDocument.Transport[] transportArray = this.partyInfo.getTransportArray();
            transport = new String[transportArray.length];
            int i = 0;
            while (i < transportArray.length) {
                transport[i] = transportArray[i].getTransportId();
                ++i;
            }
            return transport;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setEndpointwithDeliveryChannel(String _deliveryChannelId, String _endpoint) throws EbmsCpaException {
        try {
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "'] where $x/tp:DeliveryChannel[@tp:channelId='" + _deliveryChannelId + "'] return $x/tp:DeliveryChannel";
            DeliveryChannelDocument[] results_deliveryChannels = (DeliveryChannelDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            DeliveryChannelDocument.DeliveryChannel deliveryChannel = results_deliveryChannels[0].getDeliveryChannel();
            String transportId = deliveryChannel.getTransportId();
            pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:Transport[@tp:transportId='" + transportId + "']/tp:TransportReceiver/tp:Endpoint";
            EndpointDocument.Endpoint[] results_endpoint = (EndpointDocument.Endpoint[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
            results_endpoint[0].setUri(_endpoint);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String[] getEndpointsWithDefaultChannelUnderTransport() throws EbmsCpaException {
        try {
            String[] endPoint = null;
            String channelId = null;
            String transportId = null;
            channelId = this.partyInfo.getDefaultMshChannelId();
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "'] where $x/tp:DeliveryChannel[@tp:channelId='" + channelId + "'] return $x/tp:Transport";
            TransportDocument[] results_transport = (TransportDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            transportId = results_transport[0].getTransport().getTransportId();
            pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:Transport[@tp:transportId='" + transportId + "']/tp:TransportReceiver/tp:Endpoint";
            EndpointDocument.Endpoint[] result_endpoints = (EndpointDocument.Endpoint[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
            endPoint = new String[result_endpoints.length];
            int i = 0;
            while (i < result_endpoints.length) {
                endPoint[i] = result_endpoints[i].getUri();
                ++i;
            }
            return endPoint;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String[] getEndpointsUnderTransport(String _action) throws EbmsCpaException {
        try {
            String[] endPoint = null;
            String channelId = null;
            String transportId = null;
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "'] where $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanReceive/tp:ThisPartyActionBinding[@tp:action='" + _action + "'] return $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanReceive/tp:ThisPartyActionBinding/tp:ChannelId";
            ChannelIdDocument[] results_channelId = (ChannelIdDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            channelId = results_channelId[0].getChannelId();
            pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo where $x/tp:DeliveryChannel[@tp:channelId='" + channelId + "'] return $x/tp:DeliveryChannel";
            DeliveryChannelDocument[] results_deliveryChannel = (DeliveryChannelDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            transportId = results_deliveryChannel[0].getDeliveryChannel().getTransportId();
            pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:Transport[@tp:transportId='" + transportId + "']/tp:TransportReceiver/tp:Endpoint";
            EndpointDocument.Endpoint[] result_endpoints = (EndpointDocument.Endpoint[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
            endPoint = new String[result_endpoints.length];
            int i = 0;
            while (i < result_endpoints.length) {
                endPoint[i] = result_endpoints[i].getUri();
                ++i;
            }
            return endPoint;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setReliableMessagingbySenderUnderDocExchange(String _action, int _retries, GDuration _retryInterval, MessageOrderSemanticsType.Enum _messageOrderSemantics) throws EbmsCpaException {
        try {
            ReliableMessaging reliableMessaging = this.getReliableMessagebySenderUnderDocExchange(_action);
            if (_retries != -1) {
                reliableMessaging.setRetries(_retries);
            }
            if (_retryInterval != null) {
                reliableMessaging.setRetryInterval(_retryInterval);
            }
            if (_messageOrderSemantics != null) {
                reliableMessaging.setMessageOrderSemantics(_messageOrderSemantics);
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setReliableMessagingbyReceiverUnderDocExchange(String _action, int _retries, GDuration _retryInterval, MessageOrderSemanticsType.Enum _messageOrderSemantics) throws EbmsCpaException {
        try {
            ReliableMessaging reliableMessaging = this.getReliableMessagebyReceiverUnderDocExchange(_action);
            if (_retries != -1) {
                reliableMessaging.setRetries(_retries);
            }
            if (_retryInterval != null) {
                reliableMessaging.setRetryInterval(_retryInterval);
            }
            if (_messageOrderSemantics != null) {
                reliableMessaging.setMessageOrderSemantics(_messageOrderSemantics);
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public ReliableMessaging getReliableMessaing(String _action, String _role) throws EbmsCpaException {
        try {
            ReliableMessaging reliableMessaging = null;
            String channelId = null;
            String docExchangeId = null;
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "";
            pathExpression = _role.toLowerCase().equals("sender") ? "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "'] where $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding[@tp:action='" + _action + "'] return $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding/tp:ChannelId" : "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "'] where $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanReceive/tp:ThisPartyActionBinding[@tp:action='" + _action + "'] return $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanReceive/tp:ThisPartyActionBinding/tp:ChannelId";
            ChannelIdDocument[] results_channelId = (ChannelIdDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            channelId = results_channelId[0].getChannelId();
            pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo where $x/tp:DeliveryChannel[@tp:channelId='" + channelId + "'] return $x/tp:DeliveryChannel";
            DeliveryChannelDocument[] results_deliveryChannel = (DeliveryChannelDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            docExchangeId = results_deliveryChannel[0].getDeliveryChannel().getDocExchangeId();
            if (_role.toLowerCase().equals("sender")) {
                pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:DocExchange[@tp:docExchangeId='" + docExchangeId + "']/tp:ebXMLSenderBinding/tp:ReliableMessaging";
                ReliableMessagingDocument.ReliableMessaging[] results_reliableMessaging = (ReliableMessagingDocument.ReliableMessaging[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
                reliableMessaging = new ReliableMessaging(results_reliableMessaging[0]);
            } else if (_role.toLowerCase().equals("receiver")) {
                pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:DocExchange[@tp:docExchangeId='" + docExchangeId + "']/tp:ebXMLReceiverBinding/tp:ReliableMessaging";
                ReliableMessagingDocument.ReliableMessaging[] results_reliableMessaging = (ReliableMessagingDocument.ReliableMessaging[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
                reliableMessaging = new ReliableMessaging(results_reliableMessaging[0]);
            }
            return reliableMessaging;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public ReliableMessaging getReliableMessagebySenderUnderDocExchange(String action) throws EbmsCpaException {
        try {
            return this.getReliableMessaing(action, "sender");
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public ReliableMessaging getReliableMessagebyReceiverUnderDocExchange(String action) throws EbmsCpaException {
        try {
            return this.getReliableMessaing(action, "receiver");
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public DocExchangeDocument.DocExchange addDocExchange(ReliableMessaging _senderRm, GDuration _senderPersistDuration, SenderNonRepudiation _senderNonRepudiation, ReliableMessaging _receiverRm, GDuration _receiverPersistDuration, ReceiverNonRepudiation _receiverNonRepudiation) throws EbmsCpaException {
        try {
            DocExchangeDocument.DocExchange docExchange = this.partyInfo.addNewDocExchange();
            EbXMLSenderBindingDocument.EbXMLSenderBinding senderBinding = docExchange.addNewEbXMLSenderBinding();
            senderBinding.setVersion("2.0");
            ReliableMessagingDocument.ReliableMessaging senderReliableMessaging = senderBinding.addNewReliableMessaging();
            senderReliableMessaging.setRetries(new BigInteger(new Integer(_senderRm.getRetries()).toString()));
            senderReliableMessaging.setRetryInterval(_senderRm.getRertryInterval());
            senderReliableMessaging.setMessageOrderSemantics(_senderRm.getMessageOrderSemantics());
            senderBinding.setPersistDuration(_senderPersistDuration);
            if (_senderNonRepudiation != null) {
                SenderNonRepudiationDocument.SenderNonRepudiation senderNonRepudiation = senderBinding.addNewSenderNonRepudiation();
                ProtocolType tmp = ProtocolType.Factory.newInstance();
                tmp.setStringValue(_senderNonRepudiation.getNonRepudiationProtocol());
                senderNonRepudiation.setNonRepudiationProtocol(tmp);
                senderNonRepudiation.setHashFunction(_senderNonRepudiation.getHashFunction());
                int i = 0;
                while (i < _senderNonRepudiation.getSignatureAlgorithms().length) {
                    SignatureAlgorithmDocument.SignatureAlgorithm signatureAlgorithm = SignatureAlgorithmDocument.SignatureAlgorithm.Factory.newInstance();
                    signatureAlgorithm.setStringValue(_senderNonRepudiation.getSignatureAlgorithms()[i]);
                    senderNonRepudiation.setSignatureAlgorithmArray(i, signatureAlgorithm);
                    ++i;
                }
                CertificateRefType crt = CertificateRefType.Factory.newInstance();
                crt.setCertId(_senderNonRepudiation.getCertId());
            }
            EbXMLReceiverBindingDocument.EbXMLReceiverBinding receiverBinding = docExchange.addNewEbXMLReceiverBinding();
            receiverBinding.setVersion("2.0");
            ReliableMessagingDocument.ReliableMessaging receiverReliableMessaging = senderBinding.addNewReliableMessaging();
            receiverReliableMessaging.setRetries(new BigInteger(new Integer(_receiverRm.getRetries()).toString()));
            receiverReliableMessaging.setRetryInterval(_receiverRm.getRertryInterval());
            receiverReliableMessaging.setMessageOrderSemantics(_receiverRm.getMessageOrderSemantics());
            receiverBinding.setPersistDuration(_receiverPersistDuration);
            if (_receiverNonRepudiation != null) {
                ReceiverNonRepudiationDocument.ReceiverNonRepudiation receiverNonRepudiation = receiverBinding.addNewReceiverNonRepudiation();
                ProtocolType tmp = ProtocolType.Factory.newInstance();
                tmp.setStringValue(_senderNonRepudiation.getNonRepudiationProtocol());
                receiverNonRepudiation.setNonRepudiationProtocol(tmp);
                receiverNonRepudiation.setHashFunction(_receiverNonRepudiation.getHashFunction());
                int i = 0;
                while (i < _receiverNonRepudiation.getSignatureAlgorithms().length) {
                    SignatureAlgorithmDocument.SignatureAlgorithm signatureAlgorithm = SignatureAlgorithmDocument.SignatureAlgorithm.Factory.newInstance();
                    signatureAlgorithm.setStringValue(_senderNonRepudiation.getSignatureAlgorithms()[i]);
                    receiverNonRepudiation.setSignatureAlgorithmArray(i, signatureAlgorithm);
                    ++i;
                }
                SecurityDetailsRefType sdrt = SecurityDetailsRefType.Factory.newInstance();
                sdrt.setSecurityId(_receiverNonRepudiation.getSecurityId());
                receiverNonRepudiation.setSigningSecurityDetailsRef(sdrt);
            }
            return docExchange;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setReceiverNonRepudiationUnderDocExchange(String _action, String _nonRepudiationProtocol, String _hashFunction, String[] _signatureAlgorithms, String _securityId) throws EbmsCpaException {
        try {
            ReceiverNonRepudiation receiverNonRepudiation = (ReceiverNonRepudiation)this.getNonRepudiationUnderDocExchange(_action, "receiver");
            if (receiverNonRepudiation != null) {
                receiverNonRepudiation.setNonRepudiationProtocol(_nonRepudiationProtocol);
                receiverNonRepudiation.setHashFunction(_hashFunction);
                receiverNonRepudiation.setSecurityId(_securityId);
                int i = 0;
                while (i < _signatureAlgorithms.length) {
                    receiverNonRepudiation.setSignatureAlgorithm(i, _signatureAlgorithms[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String[] getDocExchangeIds() throws EbmsCpaException {
        try {
            String[] docExchange = null;
            DocExchangeDocument.DocExchange[] docExchangeArray = this.partyInfo.getDocExchangeArray();
            docExchange = new String[docExchangeArray.length];
            int i = 0;
            while (i < docExchangeArray.length) {
                docExchange[i] = docExchangeArray[i].getDocExchangeId();
                ++i;
            }
            return docExchange;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public NonRepudiation getNonRepudiationUnderDocExchangeByDocExchangeId(String _docExchange, String _role) throws EbmsCpaException {
        try {
            NonRepudiation nonRepudiation = null;
            String channelId = null;
            String docExchangeId = null;
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = null;
            channelId = this.partyInfo.getDefaultMshChannelId();
            pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo where $x/tp:DeliveryChannel[@tp:channelId='" + channelId + "'] return $x/tp:DeliveryChannel";
            DeliveryChannelDocument[] results_deliveryChannel = (DeliveryChannelDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            docExchangeId = results_deliveryChannel[0].getDeliveryChannel().getDocExchangeId();
            if (_role.toLowerCase().equals("sender")) {
                pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:DocExchange[@tp:docExchangeId='" + docExchangeId + "']/tp:ebXMLSenderBinding/tp:SenderNonRepudiation";
                SenderNonRepudiationDocument.SenderNonRepudiation[] result_senderNonRepudiation = (SenderNonRepudiationDocument.SenderNonRepudiation[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
                nonRepudiation = new SenderNonRepudiation(result_senderNonRepudiation[0]);
            } else if (_role.toLowerCase().equals("receiver")) {
                pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:DocExchange[@tp:docExchangeId='" + docExchangeId + "']/tp:ebXMLReceiverBinding/tp:ReceiverNonRepudiation";
                ReceiverNonRepudiationDocument.ReceiverNonRepudiation[] result_receiverNonRepudiation = (ReceiverNonRepudiationDocument.ReceiverNonRepudiation[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
                nonRepudiation = new ReceiverNonRepudiation(result_receiverNonRepudiation[0]);
            }
            return nonRepudiation;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public NonRepudiation getNonRepudiationUnderDocExchange(String _action, String _role) throws EbmsCpaException {
        try {
            NonRepudiation nonRepudiation = null;
            String channelId = null;
            String docExchangeId = null;
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "";
            pathExpression = _role.toLowerCase().equals("sender") ? "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "'] where $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding[@tp:action='" + _action + "'] return $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding/tp:ChannelId" : "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "'] where $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanReceive/tp:ThisPartyActionBinding[@tp:action='" + _action + "'] return $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanReceive/tp:ThisPartyActionBinding/tp:ChannelId";
            ChannelIdDocument[] results_channelId = (ChannelIdDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            channelId = results_channelId[0].getChannelId();
            pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo where $x/tp:DeliveryChannel[@tp:channelId='" + channelId + "'] return $x/tp:DeliveryChannel";
            DeliveryChannelDocument[] results_deliveryChannel = (DeliveryChannelDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            docExchangeId = results_deliveryChannel[0].getDeliveryChannel().getDocExchangeId();
            if (_role.toLowerCase().equals("sender")) {
                pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:DocExchange[@tp:docExchangeId='" + docExchangeId + "']/tp:ebXMLSenderBinding/tp:SenderNonRepudiation";
                SenderNonRepudiationDocument.SenderNonRepudiation[] result_senderNonRepudiation = (SenderNonRepudiationDocument.SenderNonRepudiation[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
                nonRepudiation = new SenderNonRepudiation(result_senderNonRepudiation[0]);
            } else if (_role.toLowerCase().equals("receiver")) {
                pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:DocExchange[@tp:docExchangeId='" + docExchangeId + "']/tp:ebXMLReceiverBinding/tp:ReceiverNonRepudiation";
                ReceiverNonRepudiationDocument.ReceiverNonRepudiation[] result_receiverNonRepudiation = (ReceiverNonRepudiationDocument.ReceiverNonRepudiation[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
                nonRepudiation = new ReceiverNonRepudiation(result_receiverNonRepudiation[0]);
            }
            return nonRepudiation;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setPersistDurationbySenderUnderDocExchange(String _action, GDuration _persistDuration) throws EbmsCpaException {
        try {
            String channelId = null;
            String docExchangeId = null;
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "'] where $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding[@tp:action='" + _action + "'] return $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding/tp:ChannelId";
            ChannelIdDocument[] results_channelId = (ChannelIdDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            channelId = results_channelId[0].getChannelId();
            pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo where $x/tp:DeliveryChannel[@tp:channelId='" + channelId + "'] return $x/tp:DeliveryChannel";
            DeliveryChannelDocument[] results_deliveryChannel = (DeliveryChannelDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            docExchangeId = results_deliveryChannel[0].getDeliveryChannel().getDocExchangeId();
            pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:DocExchange[@tp:docExchangeId='" + docExchangeId + "']/tp:ebXMLSenderBinding/tp:PersistDuration";
            XmlDuration[] results_Duration = (XmlDuration[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
            results_Duration[0].setGDurationValue(_persistDuration);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setPersistDurationbyReceiverUnderDocExchange(String _action, GDuration _persistDuration) throws EbmsCpaException {
        try {
            String channelId = null;
            String docExchangeId = null;
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "'] where $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding[@tp:action='" + _action + "'] return $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding/tp:ChannelId";
            ChannelIdDocument[] results_channelId = (ChannelIdDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            channelId = results_channelId[0].getChannelId();
            pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo where $x/tp:DeliveryChannel[@tp:channelId='" + channelId + "'] return $x/tp:DeliveryChannel";
            DeliveryChannelDocument[] results_deliveryChannel = (DeliveryChannelDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            docExchangeId = results_deliveryChannel[0].getDeliveryChannel().getDocExchangeId();
            pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:DocExchange[@tp:docExchangeId='" + docExchangeId + "']/tp:ebXMLReceiverBinding/tp:PersistDuration";
            XmlDuration[] results_Duration = (XmlDuration[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
            results_Duration[0].setGDurationValue(_persistDuration);
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public GDuration getPersistDurationbySender(String _action) throws EbmsCpaException {
        try {
            return this.getPersistDuration(_action, "Receiver");
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String getRole() throws EbmsCpaException {
        try {
            String role = null;
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "']/tp:CollaborationRole/tp:Role";
            XmlObject[] xo = this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
            System.out.println(xo.getClass().getName());
            RoleDocument.Role[] results_role = (RoleDocument.Role[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
            role = results_role[0].getName();
            return role;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public GDuration getPersistDurationbyReceiver(String _action) throws EbmsCpaException {
        try {
            return this.getPersistDuration(_action, "Receiver");
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public GDuration getPersistDuration(String _action, String _role) throws EbmsCpaException {
        try {
            GDuration persistDuration = null;
            String channelId = null;
            String docExchangeId = null;
            String tpNamespace = "declare namespace tp='http://www.oasis-open.org/committees/ebxml-cppa/schema/cpp-cpa-2_0.xsd';";
            String pathExpression = "";
            pathExpression = _role.toLowerCase().equals("sender") ? "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "'] where $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding[@tp:action='" + _action + "'] return $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanSend/tp:ThisPartyActionBinding/tp:ChannelId" : "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo[@tp:partyName='" + this.getPartyName() + "'] where $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanReceive/tp:ThisPartyActionBinding[@tp:action='" + _action + "'] return $x/tp:CollaborationRole/tp:ServiceBinding/tp:CanReceive/tp:ThisPartyActionBinding/tp:ChannelId";
            ChannelIdDocument[] results_channelId = (ChannelIdDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            channelId = results_channelId[0].getChannelId();
            pathExpression = "for $x in /tp:CollaborationProtocolAgreement/tp:PartyInfo where $x/tp:DeliveryChannel[@tp:channelId='" + channelId + "'] return $x/tp:DeliveryChannel";
            DeliveryChannelDocument[] results_deliveryChannel = (DeliveryChannelDocument[])this.partyInfo.execQuery(String.valueOf(tpNamespace) + pathExpression);
            docExchangeId = results_deliveryChannel[0].getDeliveryChannel().getDocExchangeId();
            if (_role.toLowerCase().equals("sender")) {
                pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:DocExchange[@tp:docExchangeId='" + docExchangeId + "']/tp:ebXMLSenderBinding/tp:PersistDuration";
                XmlDuration[] result_persistDurations = (XmlDuration[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
                persistDuration = result_persistDurations[0].getGDurationValue();
            } else if (_role.toLowerCase().equals("receiver")) {
                pathExpression = "/tp:CollaborationProtocolAgreement/tp:PartyInfo/tp:DocExchange[@tp:docExchangeId='" + docExchangeId + "']/tp:ebXMLReceiverBinding/tp:PersistDuration";
                XmlDuration[] result_persistDurations = (XmlDuration[])this.partyInfo.selectPath(String.valueOf(tpNamespace) + pathExpression);
                persistDuration = result_persistDurations[0].getGDurationValue();
            }
            return persistDuration;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public TransportClientSecurityDocument.TransportClientSecurity addClientTransportSecurity(String _transportId, String _certId, String _securityId) throws EbmsCpaException {
        try {
            TransportDocument.Transport[] transportArray = this.partyInfo.getTransportArray();
            int i = 0;
            while (i < transportArray.length) {
                if (transportArray[i].getTransportId().equals(_transportId) && transportArray[i].getTransportSender().getTransportClientSecurity() == null) {
                    TransportClientSecurityDocument.TransportClientSecurity tcs = transportArray[i].getTransportSender().addNewTransportClientSecurity();
                    ProtocolType protocolType = tcs.addNewTransportSecurityProtocol();
                    protocolType.setVersion("3.0");
                    protocolType.setStringValue("SSL");
                    tcs.addNewClientCertificateRef().setCertId(_certId);
                    tcs.addNewServerSecurityDetailsRef().setSecurityId(_securityId);
                    return tcs;
                }
                ++i;
            }
            return null;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setClientTransportSecurity(String _transportId, String _certId, String _securityId) throws EbmsCpaException {
        try {
            TransportDocument.Transport[] transportArray = this.partyInfo.getTransportArray();
            int i = 0;
            while (i < transportArray.length) {
                if (transportArray[i].getTransportId().equals(_transportId)) {
                    TransportClientSecurityDocument.TransportClientSecurity tcs = transportArray[i].getTransportSender().getTransportClientSecurity();
                    if (_certId != null) {
                        tcs.getClientCertificateRef().setCertId(_certId);
                    }
                    if (_securityId != null) {
                        tcs.getServerSecurityDetailsRef().setSecurityId(_securityId);
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String getTransportClientSecurity(String _transportId) throws EbmsCpaException {
        try {
            TransportDocument.Transport[] transportArray = this.partyInfo.getTransportArray();
            int i = 0;
            while (i < transportArray.length) {
                if (transportArray[i].getTransportId().equals(_transportId)) {
                    TransportClientSecurityDocument.TransportClientSecurity tcs = transportArray[i].getTransportSender().getTransportClientSecurity();
                    return tcs.getClientCertificateRef().getCertId();
                }
                ++i;
            }
            return null;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public TransportServerSecurityDocument.TransportServerSecurity addTransportServerSecurity(String _transportId, String _certId, String _securityId) throws EbmsCpaException {
        try {
            TransportDocument.Transport[] transportArray = this.partyInfo.getTransportArray();
            int i = 0;
            while (i < transportArray.length) {
                if (transportArray[i].getTransportId().equals(_transportId) && transportArray[i].getTransportReceiver().getTransportServerSecurity() == null) {
                    TransportServerSecurityDocument.TransportServerSecurity transportServerSecurity = transportArray[i].getTransportReceiver().addNewTransportServerSecurity();
                    ProtocolType protocolType = transportServerSecurity.addNewTransportSecurityProtocol();
                    protocolType.setVersion("3.0");
                    protocolType.setStringValue("SSL");
                    transportServerSecurity.addNewServerCertificateRef().setCertId(_certId);
                    transportServerSecurity.addNewClientSecurityDetailsRef().setSecurityId(_securityId);
                    return transportServerSecurity;
                }
                ++i;
            }
            return null;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public void setTransportServerSecurity(String _transportId, String _certId, String _securityId) throws EbmsCpaException {
        try {
            TransportDocument.Transport[] transportArray = this.partyInfo.getTransportArray();
            int i = 0;
            while (i < transportArray.length) {
                if (transportArray[i].getTransportId().equals(_transportId)) {
                    TransportServerSecurityDocument.TransportServerSecurity tcs = transportArray[i].getTransportReceiver().getTransportServerSecurity();
                    if (_certId != null) {
                        tcs.getServerCertificateRef().setCertId(_certId);
                    }
                    if (_securityId != null) {
                        tcs.getClientSecurityDetailsRef().setSecurityId(_securityId);
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public String getTransportServerSecurity(String _transportId) throws EbmsCpaException {
        try {
            TransportDocument.Transport[] transportArray = this.partyInfo.getTransportArray();
            int i = 0;
            while (i < transportArray.length) {
                if (transportArray[i].getTransportId().equals(_transportId)) {
                    TransportServerSecurityDocument.TransportServerSecurity tcs = transportArray[i].getTransportReceiver().getTransportServerSecurity();
                    return tcs.getServerCertificateRef().getCertId();
                }
                ++i;
            }
            return null;
        }
        catch (Exception e) {
            throw new EbmsCpaException(0, 0, e);
        }
    }

    public X509Certificate getRootCertificate() throws EbmsCpaException {
        X509Certificate certificate = this.getCertificates()[0].getX509Certificate()[0];
        return certificate;
    }

    public X509Certificate getPartyCertificate() throws EbmsCpaException {
        X509Certificate certificate = this.getCertificates()[0].getX509Certificate()[0];
        return certificate;
    }
}

