/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.packaging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Random;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.message.util.ByteArrayDataSource;

public class EBXMLMimeMultipart {
    private static Log _log = LogFactory.getLog(EBXMLMimeMultipart.class);
    private static final String HEXMAP = "0123456789ABCDEF";
    private MimeMultipart _mimeParts;
    private ContentType _ct;

    public EBXMLMimeMultipart(ByteArrayDataSource bas) throws SOAPException {
        boolean bSinglePart = false;
        boolean bDecrypted = false;
        try {
            ContentType ct = new ContentType(bas.getContentType());
            bSinglePart = "text/xml".equalsIgnoreCase(ct.getBaseType());
            bDecrypted = "multipart/related".equalsIgnoreCase(ct.getBaseType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bSinglePart) {
            this.buildMultipartFromSinglePart(bas);
        } else {
            this.buildMultipart(bas, bDecrypted);
        }
        this.checkMimeMultipart();
    }

    private void buildMultipartFromSinglePart(ByteArrayDataSource bas) throws SOAPException {
        try {
            Random r = new Random();
            this._ct = new ContentType("multipart/related");
            this._ct.setParameter("type", "text/xml");
            this._ct.setParameter("start", "MessageContentId");
            this._ct.setParameter("boundary", "boundary");
            InternetHeaders header = new InternetHeaders();
            header.addHeader("Content-Type", bas.getContentType());
            header.addHeader("Content-ID", "MessageContentId");
            MimeBodyPart mbp = new MimeBodyPart(header, bas.toByteArrayTrim());
            this._mimeParts = new MimeMultipart("related");
            this._mimeParts.addBodyPart((BodyPart)mbp, 0);
        }
        catch (IOException ee) {
            throw new SOAPException("< SOAP-ENV:Protocol >Badly formated MIME message.");
        }
        catch (MessagingException ee) {
            throw new SOAPException("<SOAP-ENV:Protocol>Badly formated MIME message.");
        }
    }

    private void buildMultipart(ByteArrayDataSource bas, boolean bDecrypted) throws SOAPException {
        try {
            if (bDecrypted) {
                this._mimeParts = new MimeMultipart((DataSource)bas);
            }
            this._ct = new ContentType(this._mimeParts.getContentType());
        }
        catch (MessagingException ee) {
            throw new SOAPException("Badly formated MIME message.", (Throwable)ee);
        }
    }

    private void checkMimeMultipart() throws SOAPException {
        try {
            MimeBodyPart firstBP;
            String firstCID;
            String ct_type = this._ct.getParameter("type");
            String ct_baseType = this._ct.getBaseType();
            String ct_boundary = this._ct.getParameter("boundary");
            String ct_startID = this._ct.getParameter("start");
            if (!"multipart/related".equalsIgnoreCase(ct_baseType)) {
                throw new SOAPException("Invalid base type=" + ct_baseType);
            }
            if (!"text/xml".equalsIgnoreCase(ct_type)) {
                throw new SOAPException("Invalid content type=" + ct_type);
            }
            if (ct_boundary == null || ct_boundary.length() == 0) {
                throw new SOAPException("Empty MIME Boundary.");
            }
            if (ct_startID != null && ct_startID.length() > 0 && this.getCount() > 0 && (firstCID = (firstBP = this.getBodyPart(0)).getContentID()) != null) {
                String bracketStartID = ct_startID;
                if (!ct_startID.startsWith("<") && !ct_startID.endsWith(">")) {
                    bracketStartID = String.valueOf('<') + ct_startID + '>';
                }
                if (!(ct_startID.equals(firstCID) || bracketStartID.equals(firstCID) || ct_startID.equals(EBXMLMimeMultipart.decodeURL(firstCID)) || bracketStartID.equals(EBXMLMimeMultipart.decodeURL(firstCID)))) {
                    _log.info((Object)("Content 'start' field(" + ct_startID + ") not equal to first body part's Content-ID(" + firstCID + ")."));
                    throw new SOAPException("Content 'start' field not equal to first body part's Content-ID.");
                }
            }
        }
        catch (SOAPException ee) {
            throw ee;
        }
        catch (MessagingException ee) {
            throw new SOAPException("Failed to parse MIME data.", (Throwable)ee);
        }
        catch (Throwable ee) {
            _log.error((Object)"trp.ebxml.log.0009", ee);
            throw new SOAPException("SOAP-ENV:Server.Exception:", ee);
        }
    }

    public MimeBodyPart getBodyPart(int index) {
        if (this._mimeParts == null) {
            return null;
        }
        try {
            return (MimeBodyPart)this._mimeParts.getBodyPart(index);
        }
        catch (MessagingException me) {
            throw new IndexOutOfBoundsException(me.getMessage());
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public MimeBodyPart getBodyPart(String CID) {
        if (this._mimeParts == null) {
            return null;
        }
        try {
            return (MimeBodyPart)this._mimeParts.getBodyPart(CID);
        }
        catch (MessagingException me) {
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
        catch (IndexOutOfBoundsException iobe) {
            return null;
        }
    }

    public MimeBodyPart findBodyPart(String uri) {
        block7: {
            if (this._mimeParts == null || uri == null) {
                return null;
            }
            try {
                if (uri.length() > 4 && uri.substring(0, 4).equalsIgnoreCase("cid:")) {
                    String cid = EBXMLMimeMultipart.decode(uri.substring(4));
                    try {
                        return (MimeBodyPart)this._mimeParts.getBodyPart(cid);
                    }
                    catch (NullPointerException nullPointerException) {
                        break block7;
                    }
                }
                return this.findPartByLocation(uri);
            }
            catch (MessagingException messagingException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    public MimeBodyPart findPartByLocation(String uri) {
        String baseUri;
        block7: {
            baseUri = this.getBaseURI();
            uri = EBXMLMimeMultipart.normalizeURI(uri, baseUri);
            if (uri != null) break block7;
            return null;
        }
        try {
            int ii = 0;
            while (ii < this._mimeParts.getCount()) {
                MimeBodyPart part = this.getBodyPart(ii);
                if (part != null) {
                    String partUri = part.getContentID();
                    if (partUri == null) {
                        partUri = part.getHeader("Content-Location", null);
                    }
                    if (uri.equals(EBXMLMimeMultipart.normalizeURI(partUri, baseUri))) {
                        return part;
                    }
                }
                ++ii;
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return null;
    }

    public String getBaseURI() {
        String baseUri = null;
        try {
            baseUri = this.getRootPart().getContentID();
            if (baseUri == null) {
                baseUri = this.getRootPart().getHeader("Content-Location", null);
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        if (baseUri == null) {
            baseUri = "thismessage:/";
        }
        return baseUri;
    }

    public MimeBodyPart getRootPart() throws MessagingException {
        String startCid;
        MimeBodyPart rootPart = null;
        if (this.getCount() > 1 && (startCid = this._ct.getParameter("start")) != null) {
            rootPart = this.getBodyPart(EBXMLMimeMultipart.decode(startCid));
        }
        if (rootPart == null) {
            rootPart = this.getBodyPart(0);
        }
        return rootPart;
    }

    public ContentType getContentType() {
        if (this._ct == null) {
            return null;
        }
        return this._ct;
    }

    public String getContentTypeString() {
        if (this._mimeParts != null) {
            return null;
        }
        return this._mimeParts.getContentType();
    }

    public int getCount() throws MessagingException {
        if (this._mimeParts == null) {
            return 0;
        }
        return this._mimeParts.getCount();
    }

    public static String decode(String ss) {
        StringBuffer ret = new StringBuffer();
        int ii = 0;
        while (ii < ss.length()) {
            char cc = ss.charAt(ii);
            switch (cc) {
                case '+': {
                    ret.append(' ');
                    break;
                }
                case '%': {
                    ret.append((char)((HEXMAP.indexOf(ss.charAt(++ii)) << 4) + HEXMAP.indexOf(ss.charAt(++ii))));
                    break;
                }
                default: {
                    ret.append(cc);
                }
            }
            ++ii;
        }
        return ret.toString();
    }

    public static String normalizeURI(String uri, String baseUri) {
        String scheme;
        int p1 = uri.indexOf(58);
        if (p1 >= 0 && (scheme = uri.substring(0, p1)).indexOf(47) == -1 && scheme.indexOf(63) == -1 && scheme.indexOf(35) == -1) {
            return uri;
        }
        return String.valueOf(baseUri) + uri;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("[Parts={");
        if (this._mimeParts != null) {
            try {
                int ii = 0;
                while (ii < this.getCount()) {
                    if (ii > 0) {
                        pw.print(", ");
                    }
                    MimeBodyPart mbp = this.getBodyPart(ii);
                    pw.print("[cid:" + mbp.getContentID() + " type: " + mbp.getContentType() + " enc: " + mbp.getEncoding() + "]");
                    ++ii;
                }
            }
            catch (MessagingException me) {
                _log.info((Object)me.getMessage());
            }
        }
        pw.print("}]");
        return sw.toString();
    }

    public static String decodeURL(String theURL) {
        if (theURL == null) {
            return null;
        }
        int theSize = theURL.length();
        StringBuffer decoded = new StringBuffer(theSize);
        int ii = 0;
        while (ii < theSize) {
            char ch = theURL.charAt(ii);
            if (ch == '%') {
                ch = theURL.charAt(++ii);
                int kk = Character.digit(ch, 16);
                kk *= 16;
                ch = theURL.charAt(++ii);
                decoded.append((char)(kk += Character.digit(ch, 16)));
            } else if (ch == '+') {
                decoded.append(' ');
            } else {
                decoded.append(ch);
            }
            ++ii;
        }
        return decoded.toString();
    }

    public MimeMultipart getMultiPart() {
        return this._mimeParts;
    }
}

