/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.packaging.impl;

import java.util.Iterator;
import java.util.Random;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.kldp.ebmsh.message.packaging.AckRequested;
import org.kldp.ebmsh.message.packaging.Acknowledgment;
import org.kldp.ebmsh.message.packaging.Action;
import org.kldp.ebmsh.message.packaging.CPAId;
import org.kldp.ebmsh.message.packaging.ConversationId;
import org.kldp.ebmsh.message.packaging.EbxmlHeader;
import org.kldp.ebmsh.message.packaging.ErrorList;
import org.kldp.ebmsh.message.packaging.From;
import org.kldp.ebmsh.message.packaging.MessageData;
import org.kldp.ebmsh.message.packaging.MessageHeader;
import org.kldp.ebmsh.message.packaging.MessageOrder;
import org.kldp.ebmsh.message.packaging.Service;
import org.kldp.ebmsh.message.packaging.SyncReply;
import org.kldp.ebmsh.message.packaging.To;
import org.kldp.ebmsh.message.packaging.impl.AckRequestedImpl;
import org.kldp.ebmsh.message.packaging.impl.AcknowledgmentImpl;
import org.kldp.ebmsh.message.packaging.impl.EbxmlElementImpl;
import org.kldp.ebmsh.message.packaging.impl.ErrorListImpl;
import org.kldp.ebmsh.message.packaging.impl.MessageHeaderImpl;
import org.kldp.ebmsh.message.packaging.impl.MessageOrderImpl;
import org.kldp.ebmsh.message.packaging.impl.SyncReplyImpl;

public class EbxmlHeaderImpl
extends EbxmlElementImpl
implements EbxmlHeader {
    protected SOAPHeader soapHeader = null;

    public EbxmlHeaderImpl() {
    }

    public EbxmlHeaderImpl(SOAPEnvelope env, SOAPHeader soapHeader) throws SOAPException {
        super(env, (SOAPElement)soapHeader);
        this.soapHeader = soapHeader;
    }

    public MessageHeader addMessageHeader() throws SOAPException {
        Name hdrName = this.env.createName("MessageHeader", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPHeaderElement she = this.soapHeader.addHeaderElement(hdrName);
        MessageHeaderImpl messageHeader = new MessageHeaderImpl(this.env, she);
        messageHeader.setVersion("2.0");
        messageHeader.setMustUnderstand(true);
        From from = messageHeader.addFrom();
        To to = messageHeader.addTo();
        CPAId cpaId = messageHeader.addCPAId();
        ConversationId conversationId = messageHeader.addConversationId();
        Service service = messageHeader.addService();
        Action action = messageHeader.addAction();
        MessageData messageData = messageHeader.addMessageData();
        return messageHeader;
    }

    public MessageHeader getMessageHeader() throws SOAPException {
        SOAPElement soe = this.getFirstChildElement("MessageHeader");
        return new MessageHeaderImpl(this.env, (SOAPHeaderElement)soe);
    }

    public boolean hasMessageHeader() throws SOAPException {
        return this.hasElement("MessageHeader");
    }

    public ErrorList addErrorList() throws SOAPException {
        Name hdrName = this.env.createName("ErrorList", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPHeaderElement she = this.soapHeader.addHeaderElement(hdrName);
        ErrorListImpl errList = new ErrorListImpl(this.env, she);
        errList.setVersion("2.0");
        errList.setMustUnderstand(true);
        return errList;
    }

    public ErrorList getErrorList() throws SOAPException {
        SOAPElement se = this.getFirstChildElement("ErrorList");
        return new ErrorListImpl(this.env, (SOAPHeaderElement)se);
    }

    public SyncReply addSyncReply() throws SOAPException {
        Name hdrName = this.env.createName("SyncReply", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPHeaderElement she = this.soapHeader.addHeaderElement(hdrName);
        SyncReplyImpl sync = new SyncReplyImpl(this.env, she);
        Random r = new Random();
        sync.setId(String.valueOf(r.nextLong()));
        sync.setVersion("2.0");
        sync.setMustUnderstand(true);
        sync.setActor("http://schemas.xmlsoap.org/soap/actor/next");
        return sync;
    }

    public SyncReply getSyncReply() throws SOAPException {
        SOAPElement se = this.getFirstChildElement("SyncReply");
        return new SyncReplyImpl(this.env, (SOAPHeaderElement)se);
    }

    public boolean hasSyncReply() throws SOAPException {
        return this.hasElement("SyncReply");
    }

    public Acknowledgment addAcknowledgment() throws SOAPException {
        Name hdrName = this.env.createName("Acknowledgment", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPHeaderElement she = this.soapHeader.addHeaderElement(hdrName);
        AcknowledgmentImpl ack = new AcknowledgmentImpl(this.env, she);
        ack.setVersion("2.0");
        ack.setMustUnderstand(true);
        return ack;
    }

    public Acknowledgment getAcknowledgment() throws SOAPException {
        SOAPElement se = this.getFirstChildElement("Acknowledgment");
        return new AcknowledgmentImpl(this.env, (SOAPHeaderElement)se);
    }

    public boolean hasAcknowledgment() throws SOAPException {
        return this.hasElement("Acknowledgment");
    }

    public boolean hasErrorList() throws SOAPException {
        return this.hasElement("ErrorList");
    }

    public AckRequested addAckRequested() throws SOAPException {
        SOAPElement se = this.addUniqueEbxmlChildElement("AckRequested");
        AckRequestedImpl ack = new AckRequestedImpl(this.env, (SOAPHeaderElement)se);
        ack.setVersion("2.0");
        ack.setMustUnderstand(true);
        return ack;
    }

    public AckRequested getAckRequested() throws SOAPException {
        SOAPElement se = this.getFirstChildElement("AckRequested");
        return new AckRequestedImpl(this.env, (SOAPHeaderElement)se);
    }

    public boolean hasAckRequested() throws SOAPException {
        return this.hasElement("AckRequested");
    }

    public MessageOrder addMessageOrder() throws SOAPException {
        SOAPElement se = this.addUniqueEbxmlChildElement("MessageOrder");
        MessageOrderImpl order = new MessageOrderImpl(this.env, (SOAPHeaderElement)se);
        order.setVersion("2.0");
        order.setMustUnderstand(true);
        return order;
    }

    public MessageOrder getMessageOrder() throws SOAPException {
        SOAPElement se = this.getFirstChildElement("MessageOrder");
        return new MessageOrderImpl(this.env, (SOAPHeaderElement)se);
    }

    public boolean hasMessageOrder() throws SOAPException {
        return this.hasElement("MessageOrder");
    }

    public SOAPHeaderElement addHeaderElement(Name arg0) throws SOAPException {
        return this.soapHeader.addHeaderElement(arg0);
    }

    public Iterator examineHeaderElements(String arg0) {
        return this.soapHeader.examineHeaderElements(arg0);
    }

    public Iterator extractHeaderElements(String arg0) {
        return this.soapHeader.extractHeaderElements(arg0);
    }
}

