/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.packaging.validation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.EbmsException;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.packaging.impl.ErrorMessage;
import org.kldp.ebmsh.message.util.MessageBuilderUtil;
import org.kldp.util.log.LogUtil;

public class EbmsEbxmlValidationException
extends EbmsException {
    private static Log log = LogFactory.getLog(EbmsEbxmlValidationException.class);
    private String _errorCode;
    private String _errorString;
    private String _severity;
    private String _location;
    private String _reftomsgid;

    public EbmsEbxmlValidationException(String errorCode, String severity, String errorString, String location) {
        this._errorCode = errorCode;
        this._errorString = errorString;
        this._severity = severity;
        this._location = location;
    }

    public void setrefToMsgId(String ref) {
        this._reftomsgid = ref;
    }

    public EbxmlMessage getEbxmlMessage(EbxmlMessage msg) {
        try {
            ErrorMessage errMsg = MessageBuilderUtil.buildMessageErrorMessage(msg);
            errMsg.setError("urn:oasis:names:tc:ebxml-msg:service:errors", this._errorCode, this._severity, this._location, this._errorString);
            return errMsg;
        }
        catch (Exception e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
            return null;
        }
    }

    public String _getErrorCode() {
        return this._errorCode;
    }

    public String getErrorString() {
        return this._errorString;
    }

    public String getLocation() {
        return this._location;
    }
}

