/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.persistant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.message.packaging.EbmsEbxmlMessageException;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.persistant.EbmsPersistantException;
import org.kldp.ebmsh.message.util.Serializer;
import org.kldp.util.io.FileIoUtil;

public class FileDAO {
    private static final Log log = LogFactory.getLog(FileDAO.class);

    FileDAO() {
    }

    EbxmlMessage getEbxmlMessageFromFile(String filePath) throws EbmsPersistantException {
        EbxmlMessage msg = null;
        FileInputStream fin = null;
        try {
            try {
                fin = new FileInputStream(new File(filePath));
                msg = Serializer.deserialize(fin);
                fin.close();
            }
            catch (FileNotFoundException e) {
                throw new EbmsPersistantException(1, 0, "\ud30c\uc77c\uc744 \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4", e);
            }
            catch (IOException e) {
                throw new EbmsPersistantException(1, 0, "\ud30c\uc77c\uc5d0\uc11c \uba54\uc2dc\uc9c0\ub97c \uc0dd\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4", e);
            }
            catch (EbmsEbxmlMessageException e) {
                throw new EbmsPersistantException(1, 0, "\ud30c\uc77c\uc5d0\uc11c \uba54\uc2dc\uc9c0\ub97c \uc0dd\uc131\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4", e);
            }
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception exception) {}
            }
        }
        return msg;
    }

    void storeEbxmlMessageToFile(EbxmlMessage msg, String filePath) throws EbmsPersistantException {
        log.info((Object)"\ud30c\uc77c\uc5d0 \uba54\uc2dc\uc9c0\ub97c \uae30\ub85d \ud569\ub2c8\ub2e4");
        try {
            Date date = new Date();
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
            String dateDirectoryName = sd.format(date);
            this.checkMessageDirectory(dateDirectoryName);
            File file = new File(filePath);
            if (file.exists()) {
                log.info((Object)"\uac19\uc740 \uc774\ub984\uc758 \uba54\uc2dc\uc9c0\uac00 \uc774\ubbf8 \uc874\uc7ac\ud569\ub2c8\ub2e4. \ub36e\uc5b4 \uc501\ub2c8\ub2e4.");
            }
            FileOutputStream fo = new FileOutputStream(file);
            log.info((Object)("\uc800\uc7a5 \uacbd\ub85c: " + file.getAbsolutePath()));
            Serializer.serialize(msg, fo);
            fo.flush();
            fo.close();
        }
        catch (IOException e) {
            throw new EbmsPersistantException(1, 0, "EbxmlMessage\ub97c \ud30c\uc77c\uc5d0 \uc800\uc7a5\ud558\ub294\ub370 \uc2e4\ud328 \ud558\uc600\uc2b5\ub2c8\ub2e4. -> storeEbxmlMessage()", e);
        }
        catch (EbmsEbxmlMessageException e) {
            throw new EbmsPersistantException(1, 0, "EbxmlMessage\ub97c Serialize\ud558\ub294\ub370 \uc2e4\ud328 \ud558\uc600\uc2b5\ub2c8\ub2e4.  -> storeEbxmlMessage()", e);
        }
    }

    private void checkMessageDirectory(String dateDirectoryName) {
        FileIoUtil.directoryCreateOrNone((String)(String.valueOf(EbmsConstants.messagePath) + FileIoUtil.fileSeparatorAddOrNone((String)"incoming") + dateDirectoryName));
        FileIoUtil.directoryCreateOrNone((String)(String.valueOf(EbmsConstants.messagePath) + FileIoUtil.fileSeparatorAddOrNone((String)"outgoing") + dateDirectoryName));
        FileIoUtil.directoryCreateOrNone((String)(String.valueOf(EbmsConstants.messagePath) + FileIoUtil.fileSeparatorAddOrNone((String)"outgoing") + "ackmessage"));
    }
}

