/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.persistant;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.persistant.DbTemplate;
import org.kldp.ebmsh.message.persistant.DbWorker;
import org.kldp.ebmsh.message.persistant.EbmsPersistantException;

public class MessageStatusDAO {
    private static final Log log = LogFactory.getLog(MessageStatusDAO.class);

    public void insertMessageStatus(String messageId, int messageStatus, String statusDesc) throws EbmsPersistantException {
        final String queryStr = "insert into " + EbmsConstants.bizboxDatabaseHeaderName + "MessageStatus(MessageId, Status, StatusDesc) values(?, ?, ?)";
        int status = messageStatus;
        final Object[] parameters = new Object[]{messageId, new Integer(status), statusDesc};
        DbTemplate dbTemplate = new DbTemplate();
        dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                try {
                    runner.update(_conn, queryStr, parameters);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(1, e.getErrorCode(), e);
                }
                return null;
            }
        });
    }

    public void insertMessageStatus(EbxmlMessage ebxmlMessage, int messageStatus, String statusDesc) throws EbmsPersistantException {
        final String queryStr = "insert into " + EbmsConstants.bizboxDatabaseHeaderName + "MessageStatus(MessageId, Status, StatusDesc) values(?, ?, ?)";
        String messageId = ebxmlMessage.getMessageId();
        int status = messageStatus;
        final Object[] parameters = new Object[]{messageId, new Integer(status), statusDesc};
        DbTemplate dbTemplate = new DbTemplate();
        dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                try {
                    runner.update(_conn, queryStr, parameters);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(1, e.getErrorCode(), e);
                }
                return null;
            }
        });
    }

    public void updateMessageStatus(EbxmlMessage ebxmlMessage, int messageStatus, String statusDesc) throws EbmsPersistantException {
        final String queryStr = "update " + EbmsConstants.bizboxDatabaseHeaderName + "MessageStatus set Status=?, StatusDesc=? where MessageId=?";
        String messageId = ebxmlMessage.getMessageId();
        int status = messageStatus;
        final Object[] parameters = new Object[]{new Integer(status), statusDesc, messageId};
        DbTemplate dbTemplate = new DbTemplate();
        dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                try {
                    runner.update(_conn, queryStr, parameters);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(1, e.getErrorCode(), e);
                }
                return null;
            }
        });
    }

    public void updateMessageStatus(String messageId, int messageStatus, String statusDesc) throws EbmsPersistantException {
        final String queryStr = "update " + EbmsConstants.bizboxDatabaseHeaderName + "MessageStatus set Status=?, StatusDesc=? where MessageId=?";
        int status = messageStatus;
        final Object[] parameters = new Object[]{new Integer(status), statusDesc, messageId};
        DbTemplate dbTemplate = new DbTemplate();
        dbTemplate.executeQuery(new DbWorker(){

            public Object work(Connection _conn) throws EbmsPersistantException {
                QueryRunner runner = new QueryRunner();
                try {
                    runner.update(_conn, queryStr, parameters);
                }
                catch (SQLException e) {
                    throw new EbmsPersistantException(1, e.getErrorCode(), e);
                }
                return null;
            }
        });
    }
}

