/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.persistant;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.GDuration;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.cpa.CpaManagerFactory;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.persistant.AckMessage;
import org.kldp.ebmsh.message.persistant.AckMessageDAO;
import org.kldp.ebmsh.message.persistant.DuplicateMessageDAO;
import org.kldp.ebmsh.message.persistant.EbmsPersistantException;
import org.kldp.ebmsh.message.persistant.FileDAO;
import org.kldp.ebmsh.message.persistant.IncomingMessage;
import org.kldp.ebmsh.message.persistant.IncomingMessageDAO;
import org.kldp.ebmsh.message.persistant.MessageStatusDAO;
import org.kldp.ebmsh.message.persistant.MessageStoreDAO;
import org.kldp.ebmsh.message.persistant.OutgoingMessageDAO;
import org.kldp.ebmsh.message.persistant.TrackerDAO;
import org.kldp.ebmsh.message.util.MessageUtil;
import org.kldp.util.io.FileIoUtil;

public class PersistantStorage {
    private static Log log = LogFactory.getLog(PersistantStorage.class);

    public void saveIncomingMessageDbAndFile(EbxmlMessage msg) throws EbmsPersistantException {
        IncomingMessageDAO incomingMessageDAO = new IncomingMessageDAO();
        log.info((Object)"\ubc1b\uc740 \uba54\uc2dc\uc9c0 \uc815\ubcf4\ub97c \uc800\uc7a5\ud569\ub2c8\ub2e4");
        Date date = new Date();
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        String dateDirectoryName = sd.format(date);
        String messageFilePath = String.valueOf(FileIoUtil.fileSeparatorAddOrNone((String)"incoming")) + FileIoUtil.fileSeparatorAddOrNone((String)dateDirectoryName) + msg.getMessageId();
        try {
            incomingMessageDAO.insertIncomingMessage(msg, date.getTime(), messageFilePath);
        }
        catch (EbmsPersistantException e) {
            if (e.getErrorCode() == EbmsConstants.duplicateErrorCode) {
                incomingMessageDAO.updateIncomingMessage(msg, date.getTime(), messageFilePath);
            }
            throw e;
        }
        FileDAO fileDAO = new FileDAO();
        fileDAO.storeEbxmlMessageToFile(msg, String.valueOf(EbmsConstants.messagePath) + messageFilePath);
    }

    public void saveFailMessageToFile(EbxmlMessage ebxmlMessage) {
        log.info((Object)"\uc2e4\ud328 \uba54\uc2dc\uc9c0 \uc815\ubcf4\ub97c \uc800\uc7a5\ud569\ub2c8\ub2e4");
        String messageFilePath = String.valueOf(FileIoUtil.fileSeparatorAddOrNone((String)"fail")) + ebxmlMessage.getMessageId();
        FileDAO fileDAO = new FileDAO();
        fileDAO.storeEbxmlMessageToFile(ebxmlMessage, String.valueOf(EbmsConstants.messagePath) + messageFilePath);
    }

    public void saveMessageStore(EbxmlMessage ebxmlMessage) throws EbmsPersistantException {
        try {
            MessageStoreDAO messageStoreDAO = new MessageStoreDAO();
            log.info((Object)"\ubc1b\uc740 \uba54\uc2dc\uc9c0 META \uc815\ubcf4\ub97c \uc800\uc7a5\ud569\ub2c8\ub2e4.");
            log.info((Object)"insert(MessageId,TimeStamp,CPAId,FromPartyId,toParyId,ConversationId,Service,Action,MsgFileName,State.gotGeneralMsg) to MessageStore Table");
            messageStoreDAO.insertMessageStore(ebxmlMessage);
        }
        catch (EbmsPersistantException e) {
            if (e.getErrorCode() == EbmsConstants.duplicateErrorCode) {
                new MessageStoreDAO().updateMessageStore(ebxmlMessage);
            }
            throw e;
        }
    }

    public void saveIncomingMessageToFile(EbxmlMessage msg) throws EbmsPersistantException {
        log.info((Object)"\uba54\uc2dc\uc9c0\ub97c \ud30c\uc77c\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4.");
        Date date = new Date();
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        String dateDirectoryName = sd.format(date);
        String messageFilePath = String.valueOf(EbmsConstants.messagePath) + FileIoUtil.fileSeparatorAddOrNone((String)"incoming") + FileIoUtil.fileSeparatorAddOrNone((String)dateDirectoryName) + msg.getMessageId();
        FileDAO fileDAO = new FileDAO();
        fileDAO.storeEbxmlMessageToFile(msg, messageFilePath);
    }

    public void saveOutgoingMessageToFile(EbxmlMessage ebxmlMessage) throws EbmsPersistantException {
        log.info((Object)"\uba54\uc2dc\uc9c0\ub97c \ud30c\uc77c\uc5d0 \uc800\uc7a5\ud569\ub2c8\ub2e4.");
        Date date = new Date();
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        String dateDirectoryName = sd.format(date);
        String messageFilePath = String.valueOf(EbmsConstants.messagePath) + FileIoUtil.fileSeparatorAddOrNone((String)"outgoing") + FileIoUtil.fileSeparatorAddOrNone((String)dateDirectoryName) + ebxmlMessage.getMessageId();
        FileDAO fileDAO = new FileDAO();
        fileDAO.storeEbxmlMessageToFile(ebxmlMessage, messageFilePath);
    }

    public void saveAckMessageInfo(EbxmlMessage ackMessage) throws EbmsPersistantException {
        try {
            AckMessageDAO ackMessageDAO = new AckMessageDAO();
            ackMessageDAO.insertAckMessage(ackMessage);
        }
        catch (EbmsPersistantException e) {
            if (e.getErrorCode() == EbmsConstants.duplicateErrorCode) {
                new AckMessageDAO().updateAckMessage(ackMessage);
            }
            throw e;
        }
    }

    public void saveAckMessageToFile(EbxmlMessage msg) throws EbmsPersistantException {
        log.info((Object)"store message to filesystem.");
        String messageFilePath = String.valueOf(EbmsConstants.messagePath) + FileIoUtil.fileSeparatorAddOrNone((String)"outgoing") + FileIoUtil.fileSeparatorAddOrNone((String)"ackmessage") + msg.getMessageId();
        FileDAO fileDAO = new FileDAO();
        fileDAO.storeEbxmlMessageToFile(msg, messageFilePath);
    }

    public void insertTrackerDetail(String messageId, String state, String information) throws EbmsPersistantException {
        TrackerDAO trackerDAO = new TrackerDAO();
        trackerDAO.insertTracker(messageId, new Date().getTime(), state, information);
    }

    public boolean isDuplicated(EbxmlMessage ebxmlMessage) throws EbmsPersistantException {
        boolean result = false;
        DuplicateMessageDAO duplicateMessageDAO = new DuplicateMessageDAO();
        if (duplicateMessageDAO.duplicatePrevention(ebxmlMessage, new Date().getTime())) {
            result = true;
        }
        return result;
    }

    public EbxmlMessage getMessage(String messageId) throws EbmsPersistantException {
        IncomingMessageDAO incomingMessageDAO = new IncomingMessageDAO();
        FileDAO fileDAO = new FileDAO();
        IncomingMessage incomingMessage = incomingMessageDAO.getInComingMessage(messageId);
        String filePath = String.valueOf(EbmsConstants.messagePath) + incomingMessage.getMSGFilePath();
        EbxmlMessage ebxmlMessage = fileDAO.getEbxmlMessageFromFile(filePath);
        return ebxmlMessage;
    }

    public EbxmlMessage getAckMessage(String messageId) throws EbmsPersistantException {
        AckMessageDAO ackMessageDAO = new AckMessageDAO();
        FileDAO fileDAO = new FileDAO();
        EbxmlMessage ebxmlMessage = null;
        AckMessage ackMessage = ackMessageDAO.getAckMessageByRefToMessageId(messageId);
        String filePath = String.valueOf(EbmsConstants.messagePath) + ackMessage.getACKFileName();
        ebxmlMessage = fileDAO.getEbxmlMessageFromFile(filePath);
        return ebxmlMessage;
    }

    public void saveDuplicateMessage(EbxmlMessage ebxmlMessage) throws EbmsPersistantException {
        GDuration persistDuration = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId()).getPartyInfo(ebxmlMessage.getTo()).getPersistDurationbyReceiver(ebxmlMessage.getAction());
        long persistDurationLong = MessageUtil.gdurationToLong(persistDuration);
        long checkEndTime = new Date().getTime() + persistDurationLong;
        try {
            new DuplicateMessageDAO().insertDuplicateMessage(ebxmlMessage, checkEndTime);
        }
        catch (EbmsPersistantException e) {
            if (e.getErrorCode() == EbmsConstants.duplicateErrorCode) {
                new DuplicateMessageDAO().updateDuplicateMessage(ebxmlMessage, checkEndTime);
            }
            throw e;
        }
    }

    public void saveMessageStatus(EbxmlMessage ebxmlMessage, int messageStatus, String messageStatusDesc) throws EbmsPersistantException {
        try {
            new MessageStatusDAO().insertMessageStatus(ebxmlMessage, messageStatus, messageStatusDesc);
        }
        catch (EbmsPersistantException e) {
            if (e.getErrorCode() == EbmsConstants.duplicateErrorCode) {
                new MessageStatusDAO().updateMessageStatus(ebxmlMessage, messageStatus, messageStatusDesc);
            }
            throw e;
        }
    }

    public void saveMessageStatus(String messageId, int messageStatus, String messageStatusDesc) throws EbmsPersistantException {
        try {
            new MessageStatusDAO().insertMessageStatus(messageId, messageStatus, messageStatusDesc);
        }
        catch (EbmsPersistantException e) {
            if (e.getErrorCode() == EbmsConstants.duplicateErrorCode) {
                new MessageStatusDAO().updateMessageStatus(messageId, messageStatus, messageStatusDesc);
            }
            throw e;
        }
    }

    public void updateMessageStatus(String messageId, int messageStatus, String messageStatusDesc) throws EbmsPersistantException {
        new MessageStatusDAO().updateMessageStatus(messageId, messageStatus, messageStatusDesc);
    }

    public void saveOutgoingMessageDbAndFile(EbxmlMessage ebxmlMessage, int status) throws EbmsPersistantException {
        log.info((Object)"\ubcf4\ub0b4\ub294 \uba54\uc2dc\uc9c0 \uc815\ubcf4\ub97c \uc800\uc7a5\ud569\ub2c8\ub2e4.");
        Date date = new Date();
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        String dateDirectoryName = sd.format(date);
        String messageFilePath = String.valueOf(FileIoUtil.fileSeparatorAddOrNone((String)"outgoing")) + FileIoUtil.fileSeparatorAddOrNone((String)dateDirectoryName) + ebxmlMessage.getMessageId();
        log.info((Object)"\ud30c\uc77c\uc5d0 \uba54\uc2dc\uc9c0\ub97c \uae30\ub85d \ud569\ub2c8\ub2e4.");
        FileDAO fileDAO = new FileDAO();
        fileDAO.storeEbxmlMessageToFile(ebxmlMessage, String.valueOf(EbmsConstants.messagePath) + messageFilePath);
        log.info((Object)"DB\uc5d0 OutgoingMessage \uc815\ubcf4\ub97c \uae30\ub85d \ud569\ub2c8\ub2e4.");
        new OutgoingMessageDAO().insertOutgingMessage(ebxmlMessage, new Date().getTime(), status, messageFilePath);
    }
}

