/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.util.log.LogUtil;
import org.w3c.dom.Attr;

public class EbmsResourceResolver
extends ResourceResolverSpi {
    private static Log log = LogFactory.getLog(EbmsResourceResolver.class);
    private EbxmlMessage Msg;
    private Iterator attachments;

    public EbmsResourceResolver(EbxmlMessage msg) {
        this.Msg = msg;
    }

    public boolean engineCanResolve(Attr attr, String baseURI) {
        this.attachments = this.Msg.getAttachments();
        String href = attr.getNodeValue();
        return this.attachments != null && this.attachments.hasNext() && href.trim().startsWith("cid");
    }

    public XMLSignatureInput engineResolve(Attr attr, String uri) throws ResourceResolverException {
        XMLSignatureInput resource = null;
        String href = attr.getNodeValue();
        log.info((Object)("A HREF = " + href + "; baseURI = " + uri));
        uri = href;
        if (href.trim().equals("#SyncReply")) {
            return null;
        }
        this.attachments = this.Msg.getAttachments();
        try {
            while (this.attachments.hasNext()) {
                AttachmentPart payload = (AttachmentPart)this.attachments.next();
                log.info((Object)payload.getContentId());
                InputStream input = payload.getDataHandler().getInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int c = input.read(buffer);
                while (c != -1) {
                    out.write(buffer, 0, c);
                    c = input.read(buffer);
                }
                resource = new XMLSignatureInput(out.toByteArray());
                resource.setSourceURI(payload.getContentId());
                resource.setMIMEType(payload.getContentType());
            }
        }
        catch (IOException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        catch (SOAPException e) {
            log.fatal((Object)LogUtil.stackTraceToString((Throwable)e));
        }
        return resource;
    }
}

