/*
 * Decompiled with CFR 0.152.
 */
package org.kldp.ebmsh.message.security;

import com.softmeca.security.keystore.IKeyStoreHandler;
import com.softmeca.security.keystore.JKSKeyStoreHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPathContainer;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.kldp.ebmsh.config.EbmsConstants;
import org.kldp.ebmsh.cpa.Certificate;
import org.kldp.ebmsh.cpa.Cpa;
import org.kldp.ebmsh.cpa.CpaManagerFactory;
import org.kldp.ebmsh.cpa.DeliveryChannel;
import org.kldp.ebmsh.cpa.EbmsCpaException;
import org.kldp.ebmsh.cpa.NonRepudiation;
import org.kldp.ebmsh.cpa.PartyInfo;
import org.kldp.ebmsh.cpa.ReceiverNonRepudiation;
import org.kldp.ebmsh.cpa.SenderNonRepudiation;
import org.kldp.ebmsh.message.packaging.EbmsEbxmlMessageException;
import org.kldp.ebmsh.message.packaging.EbxmlMessage;
import org.kldp.ebmsh.message.packaging.impl.ReferenceImpl;
import org.kldp.ebmsh.message.security.EbmsKeyStoreException;
import org.kldp.ebmsh.message.security.EbmsResourceResolver;
import org.kldp.ebmsh.message.security.EbmsSignException;
import org.kldp.ebmsh.message.security.EbmsValidateException;
import org.kldp.ebmsh.message.security.SecurityUtils;
import org.kldp.ebmsh.message.util.MessageUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EbmsSignature {
    private static final Log log = LogFactory.getLog(EbmsSignature.class);
    private IKeyStoreHandler keyStoreHandler = null;

    public EbmsSignature() throws EbmsKeyStoreException {
        Init.init();
        if (EbmsConstants.keyStoreType.equalsIgnoreCase("jks")) {
            try {
                this.keyStoreHandler = new JKSKeyStoreHandler(EbmsConstants.keyStorePath, EbmsConstants.keyStorePassword, EbmsConstants.csrPath);
            }
            catch (NoSuchAlgorithmException e) {
                EbmsKeyStoreException exception = new EbmsKeyStoreException(1, 0, "Key store \ucd08\uae30\ud654 \uc2e4\ud328", e);
                throw exception;
            }
            catch (CertificateException e) {
                EbmsKeyStoreException exception = new EbmsKeyStoreException(1, 0, "Key store \ucd08\uae30\ud654 \uc2e4\ud328", e);
                throw exception;
            }
            catch (KeyStoreException e) {
                EbmsKeyStoreException exception = new EbmsKeyStoreException(1, 0, "Key store \ucd08\uae30\ud654 \uc2e4\ud328", e);
                throw exception;
            }
            catch (IOException e) {
                EbmsKeyStoreException exception = new EbmsKeyStoreException(1, 0, "Key store \ucd08\uae30\ud654 \uc2e4\ud328", e);
                throw exception;
            }
        } else {
            throw new EbmsKeyStoreException(1, 0, "\uc9c0\uc6d0 \ub418\uc9c0 \uc54a\ub294 Key store type\uc785\ub2c8\ub2e4.");
        }
    }

    public EbxmlMessage signEbxmlMessage(EbxmlMessage ebxmlMessage) throws EbmsSignException {
        EbxmlMessage signedMessage = null;
        try {
            Cpa cpaManager = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            PartyInfo partyInfo = cpaManager.getPartyInfo(ebxmlMessage.getFrom());
            SenderNonRepudiation senderNonRepudiation = (SenderNonRepudiation)partyInfo.getNonRepudiationUnderDocExchange(ebxmlMessage.getAction(), "sender");
            String certId = senderNonRepudiation.getCertId();
            Certificate certificate = partyInfo.getCertificate(certId);
            X509Certificate cert = null;
            String keyName = certificate.getKeyNames()[0];
            if (keyName == null) {
                log.fatal((Object)"CPA\uc5d0 KeyName\uc774 \uba85\uc2dc\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                throw new EbmsCpaException(1, 0, "CPA\uc5d0 KeyName\uc774 \uba85\uc2dc\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
            log.info((Object)("CPA\uc5d0 \uba85\uc2dc\ub41c KeyName -> " + keyName));
            if (certificate.getX509Certificate() == null) {
                log.info((Object)"CPA\uc5d0 \uc778\uc99d\uc11c \ub0b4\uc6a9\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
                try {
                    cert = (X509Certificate)this.keyStoreHandler.getCertificate(keyName);
                }
                catch (KeyStoreException e) {
                    throw new EbmsKeyStoreException(1, 0, "\uc778\uc99d\uc11c \uac00\uc838\uc624\uae30 \uc2e4\ud328", e);
                }
            } else {
                log.info((Object)"CPA\uc5d0 \uc778\uc99d\uc11c \ub0b4\uc6a9\uc774 \uc788\uc2b5\ub2c8\ub2e4.");
                cert = certificate.getX509Certificate()[0];
            }
            if (cert == null) {
                log.fatal((Object)"\uc778\uc99d\uc11c\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                EbmsKeyStoreException exception = new EbmsKeyStoreException(1, 0, "\uc778\uc99d\uc11c\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                throw exception;
            }
            PrivateKey privateKey = null;
            try {
                privateKey = this.keyStoreHandler.getPrivateKey(keyName, EbmsConstants.keyPassword);
            }
            catch (UnrecoverableKeyException e) {
                EbmsKeyStoreException exception = new EbmsKeyStoreException(1, 0, "Private key \uac00\uc838\uc624\uae30 \uc2e4\ud328", e);
                throw exception;
            }
            catch (NoSuchAlgorithmException e) {
                EbmsKeyStoreException exception = new EbmsKeyStoreException(1, 0, "Private key \uac00\uc838\uc624\uae30 \uc2e4\ud328", e);
                throw exception;
            }
            catch (KeyStoreException e) {
                EbmsKeyStoreException exception = new EbmsKeyStoreException(1, 0, e);
                throw exception;
            }
            signedMessage = this.signEbxmlMessage(ebxmlMessage, cert, privateKey);
        }
        catch (EbmsKeyStoreException e) {
            throw new EbmsSignException(0, 0, e);
        }
        catch (EbmsSignException e) {
            throw e;
        }
        catch (EbmsCpaException e) {
            throw new EbmsSignException(0, 0, e);
        }
        return signedMessage;
    }

    private EbxmlMessage signEbxmlMessage(EbxmlMessage ebxmlMessage, X509Certificate certificate, PrivateKey privateKey) throws EbmsSignException {
        EbxmlMessage signedMessage = null;
        SecurityUtils securityUtil = new SecurityUtils();
        try {
            byte[] soapPart = securityUtil.SOAPPartTOBytes(ebxmlMessage);
            ByteArrayInputStream bis = new ByteArrayInputStream(soapPart);
            InputSource is = new InputSource(bis);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
            Document doc = db.parse(is);
            Element headerElement = null;
            NodeList nodes = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
            if (nodes.getLength() == 0) {
                log.fatal((Object)"Header\ub97c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                EbmsEbxmlMessageException exception = new EbmsEbxmlMessageException(1, 0, "Header\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                throw exception;
            }
            log.info((Object)("Header \uac1c\uc218 -> " + nodes.getLength()));
            headerElement = (Element)nodes.item(0);
            Cpa cpaBuilder = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            PartyInfo partyInfo = cpaBuilder.getPartyInfo(ebxmlMessage.getFrom());
            NonRepudiation np = partyInfo.getNonRepudiationUnderDocExchange(ebxmlMessage.getAction(), "sender");
            String[] signAlgorithm = np.getSignatureAlgorithms();
            XMLSignature signature = new XMLSignature(doc, "", signAlgorithm[0]);
            log.info((Object)"Ebxml message sign start");
            headerElement.appendChild(signature.getElement());
            Transforms transforms = new Transforms(doc);
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            String s_xpath = "not (ancestor-or-self::node()[@soap-env:actor=\"urn:oasis:names:tc:ebxml-msg:actor:nextMSH\"] | ancestor-or-self::node()[@soap-env:actor=\"http://schemas.xmlsoap.org/soap/actor/next\"])";
            XPathContainer xc = new XPathContainer(doc);
            xc.setXPath(s_xpath);
            transforms.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xc.getElement());
            transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            String hashFunction = np.getHashFunction();
            signature.addDocument("", transforms, hashFunction, "", "http://www.w3.org/2000/09/xmldsig#Object");
            log.info((Object)"Ebxml message sign end");
            log.info((Object)"Ebxml payload sign start");
            if (ebxmlMessage.getEbxmlBody().hasManifest()) {
                ResourceResolver resolver = new ResourceResolver((ResourceResolverSpi)new EbmsResourceResolver(ebxmlMessage));
                signature.addResourceResolver(resolver);
                ArrayList it = ebxmlMessage.getEbxmlBody().getManifest().getReferences();
                int i = 0;
                while (i < it.size()) {
                    ReferenceImpl ref = (ReferenceImpl)it.get(i);
                    signature.addDocument(ref.getXlinkRef());
                    ++i;
                }
            }
            log.info((Object)"Ebxml payload sign end");
            log.info((Object)"Key info add...");
            signature.addKeyInfo(certificate);
            log.info((Object)"Signature sign...");
            signature.sign((Key)privateKey);
            signedMessage = securityUtil.updateSignedMessage(ebxmlMessage, doc);
        }
        catch (ParserConfigurationException e) {
            throw new EbmsSignException(1, 4001, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  newDocumentBuilder()", e);
        }
        catch (IOException e) {
            throw new EbmsSignException(1, 4002, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  newDocumentBuilder()", e);
        }
        catch (SAXException e) {
            throw new EbmsSignException(1, 4003, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  parse()", e);
        }
        catch (XMLSecurityException e) {
            throw new EbmsSignException(1, 4004, "Ebxml message Sign -> security sign", e);
        }
        catch (SOAPException e) {
            throw new EbmsSignException(1, 4005, "Ebxml message exception", e);
        }
        catch (EbmsEbxmlMessageException e) {
            throw new EbmsSignException(0, 0, e);
        }
        catch (EbmsCpaException e) {
            throw new EbmsSignException(0, 0, e);
        }
        return signedMessage;
    }

    public EbxmlMessage signAckMessage(EbxmlMessage ackMessage, EbxmlMessage receiveMessage) throws EbmsSignException {
        try {
            EbxmlMessage signedAckMessage = null;
            ackMessage = this.addReferenceToAckMessage(ackMessage, receiveMessage);
            signedAckMessage = this.signAckMessage(ackMessage);
            return signedAckMessage;
        }
        catch (EbmsSignException e) {
            throw e;
        }
        catch (EbmsEbxmlMessageException e) {
            throw new EbmsSignException(0, 0, e);
        }
    }

    private EbxmlMessage signAckMessage(EbxmlMessage ebxmlMessage) throws EbmsSignException {
        try {
            EbxmlMessage signedMessage = null;
            Cpa cpaManager = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            PartyInfo partyInfo = cpaManager.getPartyInfo(ebxmlMessage.getFrom());
            String defaultMshChannelId = partyInfo.getDefaultMshChannelId();
            DeliveryChannel deliveryChannel = partyInfo.getDeliveryChannel(defaultMshChannelId);
            String docExchangeId = deliveryChannel.getDocExchangeId();
            SenderNonRepudiation senderNonRepudiation = (SenderNonRepudiation)partyInfo.getNonRepudiationUnderDocExchangeByDocExchangeId(docExchangeId, "sender");
            String certId = senderNonRepudiation.getCertId();
            Certificate certificate = partyInfo.getCertificate(certId);
            X509Certificate cert = null;
            String keyName = certificate.getKeyNames()[0];
            if (keyName == null) {
                log.fatal((Object)"CPA\uc5d0 KeyName\uc774 \uba85\uc2dc\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                throw new EbmsCpaException(1, 0, "CPA\uc5d0 KeyName\uc774 \uba85\uc2dc\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
            log.info((Object)("CPA\uc5d0 \uba85\uc2dc\ub41c KeyName -> " + keyName));
            if (certificate.getX509Certificate() == null) {
                log.info((Object)"CPA\uc5d0 \uc778\uc99d\uc11c \ub0b4\uc6a9\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
                log.info((Object)("KeyStore\uc5d0\uc11c \uc778\uc99d\uc11c\ub97c \ucc3e\uc2b5\ub2c8\ub2e4. Alias -> " + keyName));
                try {
                    cert = (X509Certificate)this.keyStoreHandler.getCertificate(keyName);
                }
                catch (KeyStoreException e) {
                    throw new EbmsKeyStoreException(1, 0, "\uc778\uc99d\uc11c \uac00\uc838\uc624\uae30 \uc2e4\ud328", e);
                }
            } else {
                log.info((Object)"CPA\uc5d0 \uc778\uc99d\uc11c \ub0b4\uc6a9\uc774 \uc788\uc2b5\ub2c8\ub2e4.");
                cert = certificate.getX509Certificate()[0];
            }
            if (cert == null) {
                log.fatal((Object)"\uc778\uc99d\uc11c\ub97c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                throw new EbmsSignException(1, 4012, "\uc778\uc99d\uc11c\ub97c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            PrivateKey privateKey = null;
            try {
                privateKey = this.keyStoreHandler.getPrivateKey(keyName, EbmsConstants.keyPassword);
            }
            catch (UnrecoverableKeyException e) {
                EbmsKeyStoreException exception = new EbmsKeyStoreException(1, 0, "Private key \uac00\uc838\uc624\uae30 \uc2e4\ud328", e);
                throw exception;
            }
            catch (NoSuchAlgorithmException e) {
                EbmsKeyStoreException exception = new EbmsKeyStoreException(1, 0, "Private key \uac00\uc838\uc624\uae30 \uc2e4\ud328", e);
                throw exception;
            }
            catch (KeyStoreException e) {
                EbmsKeyStoreException exception = new EbmsKeyStoreException(1, 0, e);
                throw exception;
            }
            signedMessage = this.signAckMessage(ebxmlMessage, cert, privateKey);
            return signedMessage;
        }
        catch (EbmsCpaException e) {
            throw new EbmsSignException(0, 0, e);
        }
        catch (EbmsKeyStoreException e) {
            throw new EbmsSignException(0, 0, e);
        }
    }

    private EbxmlMessage signAckMessage(EbxmlMessage ebxmlMessage, X509Certificate certificate, PrivateKey privateKey) throws EbmsSignException {
        try {
            EbxmlMessage signedMessage = null;
            SecurityUtils securityUtil = new SecurityUtils();
            byte[] soapPart = securityUtil.SOAPPartTOBytes(ebxmlMessage);
            ByteArrayInputStream bis = new ByteArrayInputStream(soapPart);
            InputSource is = new InputSource(bis);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
            Document doc = db.parse(is);
            Element headerElement = null;
            NodeList nodes = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
            if (nodes.getLength() == 0) {
                log.fatal((Object)"Header\ub97c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                throw new EbmsSignException(1, 0, "Header\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            log.info((Object)("Header \uac1c\uc218 -> " + nodes.getLength()));
            headerElement = (Element)nodes.item(0);
            Cpa cpaBuilder = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            PartyInfo partyInfo = cpaBuilder.getPartyInfo(ebxmlMessage.getFrom());
            String defaultMshChannelId = partyInfo.getDefaultMshChannelId();
            DeliveryChannel deliveryChannel = partyInfo.getDeliveryChannel(defaultMshChannelId);
            String docExchangeId = deliveryChannel.getDocExchangeId();
            NonRepudiation np = partyInfo.getNonRepudiationUnderDocExchangeByDocExchangeId(docExchangeId, "sender");
            String[] signAlgorithm = np.getSignatureAlgorithms();
            XMLSignature signature = new XMLSignature(doc, "", signAlgorithm[0]);
            log.info((Object)"Ebxml message sign start");
            headerElement.appendChild(signature.getElement());
            Transforms transforms = new Transforms(doc);
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            String s_xpath = "not (ancestor-or-self::node()[@soap-env:actor=\"urn:oasis:names:tc:ebxml-msg:actor:nextMSH\"] | ancestor-or-self::node()[@soap-env:actor=\"http://schemas.xmlsoap.org/soap/actor/next\"])";
            XPathContainer xc = new XPathContainer(doc);
            xc.setXPath(s_xpath);
            transforms.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xc.getElement());
            transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
            String hashFunction = np.getHashFunction();
            signature.addDocument("", transforms, hashFunction);
            log.info((Object)"Ebxml message sign end");
            log.info((Object)"Ebxml payload sign start");
            if (ebxmlMessage.getEbxmlBody().hasManifest()) {
                ResourceResolver resolver = new ResourceResolver((ResourceResolverSpi)new EbmsResourceResolver(ebxmlMessage));
                signature.addResourceResolver(resolver);
                ArrayList it = ebxmlMessage.getEbxmlBody().getManifest().getReferences();
                int i = 0;
                while (i < it.size()) {
                    ReferenceImpl ref = (ReferenceImpl)it.get(i);
                    signature.addDocument(ref.getXlinkRef());
                    ++i;
                }
            }
            log.info((Object)"Ebxml payload sign end");
            log.info((Object)"Key info add...");
            signature.addKeyInfo(certificate);
            log.info((Object)"Signature sign...");
            signature.sign((Key)privateKey);
            signedMessage = securityUtil.updateSignedMessage(ebxmlMessage, doc);
            return signedMessage;
        }
        catch (ParserConfigurationException e) {
            throw new EbmsSignException(1, 4006, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  newDocumentBuilder()", e);
        }
        catch (IOException e) {
            throw new EbmsSignException(1, 4007, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  parse()", e);
        }
        catch (SAXException e) {
            throw new EbmsSignException(1, 4008, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  parse()", e);
        }
        catch (XMLSecurityException e) {
            throw new EbmsSignException(1, 4009, "Ebxml message Sign -> security sign", e);
        }
        catch (SOAPException e) {
            throw new EbmsSignException(1, 4010, "Ebxml message exception", e);
        }
        catch (EbmsSignException e) {
            throw e;
        }
        catch (EbmsCpaException e) {
            throw new EbmsSignException(0, 0, e);
        }
    }

    private Iterator generateReference(EbxmlMessage ebxmlMessage) throws EbmsSignException {
        Element headerElement;
        Document doc;
        DocumentBuilderFactory dbf;
        block13: {
            SecurityUtils securityUtil = new SecurityUtils();
            byte[] soapPart = securityUtil.SOAPPartTOBytes(ebxmlMessage);
            ByteArrayInputStream bis = new ByteArrayInputStream(soapPart);
            InputSource is = new InputSource(bis);
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
            doc = db.parse(is);
            headerElement = null;
            NodeList nodes = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
            if (nodes.getLength() != 0) {
                log.info((Object)("Header \uac1c\uc218 -> " + nodes.getLength()));
                headerElement = (Element)nodes.item(0);
                break block13;
            }
            log.fatal((Object)"Header\ub97c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return null;
        }
        try {
            Cpa cpaBuilder = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            PartyInfo partyInfo = cpaBuilder.getPartyInfo(ebxmlMessage.getFrom());
            NonRepudiation np = partyInfo.getNonRepudiationUnderDocExchange(ebxmlMessage.getAction(), "sender");
            String[] signAlgorithm = np.getSignatureAlgorithms();
            XMLSignature signature = new XMLSignature(doc, "", signAlgorithm[0]);
            log.info((Object)"Ebxml message sign start");
            headerElement.appendChild(signature.getElement());
            Transforms transforms = new Transforms(doc);
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            String s_xpath = "not (ancestor-or-self::node()[@soap-env:actor=\"urn:oasis:names:tc:ebxml-msg:actor:nextMSH\"] | ancestor-or-self::node()[@soap-env:actor=\"http://schemas.xmlsoap.org/soap/actor/next\"])";
            XPathContainer xc = new XPathContainer(doc);
            xc.setXPath(s_xpath);
            transforms.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xc.getElement());
            transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
            String hashFunction = np.getHashFunction();
            signature.addDocument("", transforms, hashFunction);
            log.info((Object)"Ebxml message sign end");
            log.info((Object)"Ebxml payload sign start");
            if (ebxmlMessage.getEbxmlBody().hasManifest()) {
                ResourceResolver resolver = new ResourceResolver((ResourceResolverSpi)new EbmsResourceResolver(ebxmlMessage));
                signature.addResourceResolver(resolver);
                ArrayList it = ebxmlMessage.getEbxmlBody().getManifest().getReferences();
                int i = 0;
                while (i < it.size()) {
                    ReferenceImpl ref = (ReferenceImpl)it.get(i);
                    signature.addDocument(ref.getXlinkRef());
                    ++i;
                }
            }
            log.info((Object)"Ebxml payload sign end");
            signature.getSignedInfo().generateDigestValues();
            String st = new String(signature.getSignedInfo().getCanonicalizedOctetStream());
            ByteArrayInputStream bis_ = new ByteArrayInputStream(st.getBytes());
            InputSource is_ = new InputSource(bis_);
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            documentFactory.setNamespaceAware(true);
            documentFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
            DocumentBuilder db_ = dbf.newDocumentBuilder();
            db_.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
            Document doc_ = db_.parse(is_);
            Node signedInfoNode = doc_.getFirstChild();
            SOAPElement signedInfoElement = MessageUtil.convertDOMToSOAPElement(ebxmlMessage.getSOAPPart().getEnvelope(), signedInfoNode);
            Name referenceName = ebxmlMessage.getSOAPPart().getEnvelope().createName("Reference", "ds", "http://www.w3.org/2000/09/xmldsig#");
            Iterator iter = signedInfoElement.getChildElements(referenceName);
            if (!iter.hasNext()) {
                throw new EbmsSignException(1, 0, "Reference element\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            return iter;
        }
        catch (ParserConfigurationException e) {
            throw new EbmsSignException(1, 4001, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  newDocumentBuilder()", e);
        }
        catch (IOException e) {
            throw new EbmsSignException(1, 4002, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  parse()", e);
        }
        catch (SAXException e) {
            throw new EbmsSignException(1, 4003, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  parse()", e);
        }
        catch (XMLSecurityException e) {
            throw new EbmsSignException(1, 4004, "Ebxml message Sign -> security sign", e);
        }
        catch (SOAPException e) {
            throw new EbmsSignException(1, 4005, "Ebxml message exception", e);
        }
        catch (EbmsCpaException e) {
            throw new EbmsSignException(0, 0, e);
        }
        catch (EbmsSignException e) {
            throw e;
        }
    }

    private EbxmlMessage addReferenceToAckMessage(EbxmlMessage ackMessage, EbxmlMessage receiveMessage) throws EbmsEbxmlMessageException {
        try {
            EbxmlMessage _ackMessage = ackMessage;
            boolean hasSignature = false;
            Name sinatureName = receiveMessage.getSOAPPart().getEnvelope().createName("Signature", "ds", "http://www.w3.org/2000/09/xmldsig#");
            Iterator iter = receiveMessage.getEbxmlHeader().getChildElements(sinatureName);
            if (iter.hasNext()) {
                log.info((Object)"Signature\uac00 \uc874\uc7ac\ud569\ub2c8\ub2e4.");
                hasSignature = true;
            } else {
                log.info((Object)"Signature \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            if (hasSignature) {
                iter = this.getReference(receiveMessage);
                while (iter.hasNext()) {
                    SOAPElement referenceElement = (SOAPElement)iter.next();
                    _ackMessage.getEbxmlHeader().getAcknowledgment().addChildElement(referenceElement);
                }
            } else {
                System.setProperty("javax.xml.soap.Name", "com.sun.xml.messaging.saaj.soap.dom4j.NameImpl");
                iter = this.generateReference(receiveMessage);
                while (iter.hasNext()) {
                    SOAPElement referenceElement = (SOAPElement)iter.next();
                    log.info((Object)"~~~~~~~~~~~!");
                    _ackMessage.getEbxmlHeader().getAcknowledgment().addChildElement(referenceElement);
                }
            }
            if (_ackMessage != null) {
                _ackMessage.saveChanges();
            }
            return _ackMessage;
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 4011, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  newDocumentBuilder()", e);
        }
        catch (EbmsEbxmlMessageException e) {
            throw e;
        }
    }

    private Iterator getReference(EbxmlMessage ebxmlMessage) throws EbmsEbxmlMessageException {
        Iterator iter_ = null;
        try {
            Name sinatureName = ebxmlMessage.getSOAPPart().getEnvelope().createName("Signature", "ds", "http://www.w3.org/2000/09/xmldsig#");
            Iterator iter = ebxmlMessage.getEbxmlHeader().getChildElements(sinatureName);
            SOAPElement signatureElement = null;
            signatureElement = (SOAPElement)iter.next();
            Name signedInfoName = ebxmlMessage.getSOAPPart().getEnvelope().createName("SignedInfo", "ds", "http://www.w3.org/2000/09/xmldsig#");
            iter = signatureElement.getChildElements(signedInfoName);
            SOAPElement signedInfoElement = (SOAPElement)iter.next();
            Name referenceName = ebxmlMessage.getSOAPPart().getEnvelope().createName("Reference", "ds", "http://www.w3.org/2000/09/xmldsig#");
            iter = signedInfoElement.getChildElements(referenceName);
            if (!iter.hasNext()) {
                log.info((Object)"Reference element\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            iter_ = iter;
        }
        catch (SOAPException e) {
            throw new EbmsEbxmlMessageException(1, 4022, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  newDocumentBuilder()", e);
        }
        return iter_;
    }

    public boolean validateEbxmlMessage(EbxmlMessage ebxmlMessage) throws EbmsValidateException {
        try {
            boolean result = false;
            SecurityUtils securityUtil = new SecurityUtils();
            byte[] soapPart = securityUtil.SOAPPartTOBytes(ebxmlMessage);
            ByteArrayInputStream bis = new ByteArrayInputStream(soapPart);
            InputSource is = new InputSource(bis);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
            Document doc = db.parse(is);
            Element signatureElement = null;
            NodeList nodes = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nodes.getLength() == 0) {
                log.fatal((Object)"Signature \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                throw new EbmsValidateException(1, 0, "Signature \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            log.info((Object)("Signature \uac1c\uc218 -> " + nodes.getLength()));
            signatureElement = (Element)nodes.item(0);
            XMLSignature signature = new XMLSignature(signatureElement, "");
            signature.getSignedInfo().addResourceResolver((ResourceResolverSpi)new EbmsResourceResolver(ebxmlMessage));
            KeyInfo keyInfo = signature.getKeyInfo();
            log.info((Object)"\uc778\uc99d\uc11c\ub97c \ucc3e\uc2b5\ub2c8\ub2e4.");
            X509Certificate cert = null;
            log.info((Object)"1 - \uba54\uc2dc\uc9c0\uc5d0\uc11c \uc778\uc99d\uc11c\ub97c \ucc3e\uc2b5\ub2c8\ub2e4.");
            if (keyInfo != null && keyInfo.containsX509Data()) {
                log.info((Object)"\uba54\uc2dc\uc9c0\uc5d0 \uc778\uc99d\uc11c\uac00 \uc874\uc7ac \ud569\ub2c8\ub2e4.");
                cert = keyInfo.getX509Certificate();
            } else {
                log.info((Object)"2 - CPA\uc5d0\uc11c \uc778\uc99d\uc11c\ub97c \ucc3e\uc2b5\ub2c8\ub2e4.");
                Cpa cpaManager = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
                PartyInfo partyInfo = cpaManager.getPartyInfo(ebxmlMessage.getFrom());
                SenderNonRepudiation senderNonRepudiation = (SenderNonRepudiation)partyInfo.getNonRepudiationUnderDocExchange(ebxmlMessage.getAction(), "sender");
                String certId = senderNonRepudiation.getCertId();
                Certificate certificate = partyInfo.getCertificate(certId);
                String keyName = certificate.getKeyNames()[0];
                if (keyName == null) {
                    log.fatal((Object)"CPA\uc5d0 KeyName\uc774 \uba85\uc2dc\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                    throw new EbmsValidateException(1, 0, "CPA\uc5d0 KeyName\uc774 \uba85\uc2dc\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                }
                log.info((Object)("CPA\uc5d0 \uba85\uc2dc\ub41c KeyName -> " + keyName));
                if (certificate.getX509Certificate() != null) {
                    cert = certificate.getX509Certificate()[0];
                } else {
                    log.info((Object)"3 - KeyStore\uc5d0\uc11c \uc778\uc99d\uc11c\ub97c \ucc3e\uc2b5\ub2c8\ub2e4.");
                    try {
                        cert = (X509Certificate)this.keyStoreHandler.getCertificate(keyName);
                    }
                    catch (KeyStoreException e) {
                        throw new EbmsKeyStoreException(1, 0, "\uc778\uc99d\uc11c \ucc3e\ub294 \uc911 \uc5d0\ub7ec", e);
                    }
                }
            }
            if (cert == null) {
                log.fatal((Object)"\uc778\uc99d\uc11c\ub97c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                throw new EbmsValidateException(1, 4016, "\uc778\uc99d\uc11c\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            log.info((Object)"\uba54\uc2dc\uc9c0\ub97c \uac80\uc99d\ud569\ub2c8\ub2e4.");
            result = this.validateMessage(signature, cert);
            if (!result) {
                log.fatal((Object)"\uba54\uc2dc\uc9c0 \uac80\uc99d \uc2e4\ud328");
                throw new EbmsValidateException(1, 4016, "\uba54\uc2dc\uc9c0 \uac80\uc99d \uc2e4\ud328");
            }
            log.info((Object)"\uba54\uc2dc\uc9c0 \uac80\uc99d \uc131\uacf5");
            return result;
        }
        catch (ParserConfigurationException e) {
            throw new EbmsValidateException(1, 4013, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  newDocumentBuilder()", e);
        }
        catch (IOException e) {
            throw new EbmsValidateException(1, 4014, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  parse()", e);
        }
        catch (SAXException e) {
            throw new EbmsValidateException(1, 4015, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  parse()", e);
        }
        catch (SOAPException e) {
            throw new EbmsValidateException(1, 4015, "Ebxml message Sign -> ebxmlMessage \ud30c\uc2f1 \uc5d0\ub7ec  parse()", e);
        }
        catch (XMLSecurityException e) {
            throw new EbmsValidateException(1, 4016, "Ebxml message Sign -> security sign", e);
        }
        catch (EbmsCpaException e) {
            throw new EbmsValidateException(1, 0, e);
        }
        catch (EbmsKeyStoreException e) {
            throw new EbmsValidateException(1, 0, e);
        }
    }

    private void validateCertificateInMessage(EbxmlMessage ebxmlMessage, X509Certificate msgCertificate) throws EbmsValidateException {
        try {
            Cpa cpaBuilder = new CpaManagerFactory().createInstance().getCpa(ebxmlMessage.getCPAId());
            PartyInfo partyInfo = cpaBuilder.getPartyInfo(ebxmlMessage.getTo());
            ReceiverNonRepudiation nonRepudiation = (ReceiverNonRepudiation)partyInfo.getNonRepudiationUnderDocExchange(ebxmlMessage.getAction(), "receiver");
            String securityId = nonRepudiation.getSecurityId();
            String[] trustAnchorIds = partyInfo.getSecurityDetailsTrustAnchorsCertIds(securityId);
            X509Certificate[] trustAnchors = new X509Certificate[trustAnchorIds.length];
            log.info((Object)("Trust Anchor\uc758 \uac1c\uc218 -> " + trustAnchorIds.length));
            HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
            int i = 0;
            while (i < trustAnchors.length) {
                Certificate certificate = partyInfo.getCertificate(trustAnchorIds[i]);
                if (certificate.getX509Certificate() == null) {
                    log.info((Object)"CPA\uc5d0 TrustAnchor \uc778\uc99d\uc11c \ub0b4\uc6a9\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
                    log.info((Object)"KeyStore\uc5d0\uc11c \ucc3e\uc2b5\ub2c8\ub2e4.");
                    String keyName = partyInfo.getCertificate(trustAnchorIds[i]).getKeyNames()[0];
                    try {
                        trustAnchors[i] = (X509Certificate)this.keyStoreHandler.getCertificate(keyName);
                    }
                    catch (KeyStoreException e) {
                        throw new EbmsKeyStoreException(1, 0, e);
                    }
                } else {
                    log.info((Object)"CPA\uc5d0 TrustAnchor \uc778\uc99d\uc11c \ub0b4\uc6a9\uc774 \uc788\uc2b5\ub2c8\ub2e4.");
                    trustAnchors[i] = partyInfo.getCertificate(trustAnchorIds[i]).getX509Certificate()[0];
                }
                if (trustAnchors[i] == null) {
                    throw new EbmsValidateException(1, 0, "TrustAnchor \uc778\uc99d\uc11c\ub97c \ucc3e\uc744\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                }
                TrustAnchor trustAnchor = new TrustAnchor(trustAnchors[i], null);
                System.out.println(trustAnchors[i].getIssuerDN());
                hashSet.add(trustAnchor);
                ++i;
            }
            PKIXParameters params = new PKIXParameters(hashSet);
            params.setRevocationEnabled(false);
            X509Certificate[] cert = new X509Certificate[]{msgCertificate};
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            CertPath path = certFact.generateCertPath(Arrays.asList(cert));
            CertPathValidator certPathValidator = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
            certPathValidator.validate(path, params);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EbmsValidateException(1, 4017, "Invalid Algorithm Parameter exception -> PKIXParameters(hashSet)", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EbmsValidateException(1, 4018, "\uc778\uc99d\uc11c Path\uc0dd\uc131 \uc5d0\ub7ec -> CertPathValidator.getInstance()", e);
        }
        catch (CertificateException e) {
            throw new EbmsValidateException(1, 4019, "\uc778\uc99d\uc11c Path\uc124\uc815 \uc5d0\ub7ec -> CertificateFactory.getInstance(X.509);", e);
        }
        catch (CertPathValidatorException e) {
            throw new EbmsValidateException(1, 4020, "Message\uc548\uc5d0 \uc788\ub294 \uc778\uc99d\uc11c \uac80\uc99d \uc2e4\ud328 -> validate()", e);
        }
        catch (EbmsCpaException e) {
            throw new EbmsValidateException(0, 0, e);
        }
        catch (EbmsKeyStoreException e) {
            throw new EbmsValidateException(0, 0, e);
        }
    }

    private boolean validateMessage(XMLSignature signature, X509Certificate certificate) throws EbmsValidateException {
        try {
            System.out.println(signature);
            System.out.println(certificate);
            return signature.checkSignatureValue(certificate);
        }
        catch (XMLSignatureException e) {
            throw new EbmsValidateException(1, 4021, "Message \uac80\uc99d \uc2e4\ud328 -> checkSignatureValue()", e);
        }
    }
}

